package xiaoman;

import cn.quantgroup.customer.Bootstrap;
import cn.quantgroup.customer.model.workorder.WorkOrderVO;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.customer.util.JSONTools;
import cn.quantgroup.customer.util.poi.ReaderTest;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.domain.Page;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * @description:
 * @author:tao
 * @create: 2020-08-14 16:28
 */

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class, webEnvironment= SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class WorkOrderTest {

    @Autowired
    private IWorkOrderService workOrderService;

    /**
     * 导入数据
     * @throws Exception
     */
    @Test
    public void workOrderTest() throws Exception {
        ReaderTest readerTest = new ReaderTest();
        readerTest.read();
        workOrderService.importData(readerTest.getList());
    }


    @Test
    public void queryPage() {
        JsonResult<Page<WorkOrderVO>> pageJsonResult = workOrderService.queryWorkOrder(1, 2, null, null);
        System.out.println(JSONTools.serialize(pageJsonResult));
    }

}
