package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.rest.param.phone.ModifyPhoneRecord;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Validated
@Slf4j
@RestController
@RequestMapping("/v1")
public class UserModifyPhoneController {
    @Autowired
    private IUserService userService;
    /**
     * 修改手机号
     */
    @PostMapping(value = "/modify/phoneNo")
    public JsonResult modifyPhoneNo(@Valid @RequestBody ModifyPhoneRecord modifyPhoneRecord) {
        if (modifyPhoneRecord.getCurPhoneNo().equals(modifyPhoneRecord.getPrevPhoneNo())) {
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PHONE_EQUALS.getMessage(), ErrorCodeEnum.PHONE_EQUALS.getCode());
        }
        return userService.submitModiyPhoneNo(modifyPhoneRecord);
    }

    /**
     *  获取修改手机号列表
     * @return
     */
    @PostMapping(value = "/modifyPhoneNolist")
    public JsonResult modifyPhoneNolist(@RequestParam Long userId,
                                        @RequestParam(defaultValue = "1", required = false) int pageNo,
                                        @RequestParam(defaultValue = "10", required = false) int pageSize) {
        return userService.modifyPhoneNolist(userId, pageNo, pageSize);
    }
}
