package cn.quantgroup.customer.service;

import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.repay.RepayInfoResult;
import cn.quantgroup.customer.rest.vo.repay.RepayOptRecord;

import java.util.List;

public interface IRepayService {
    String findRepayOrders(RepayOrderQuery repayOrderQuery);

    /**
     * 查询还款信息
     *
     * @param repayOrderQuery
     * @return
     */
    JsonResult<RepayInfoResult> queryRepayInfo(RepayOrderInfoQuery repayOrderQuery);

    /**
     * 查询还款操作记录
     *
     * @param businessFlowNo
     * @return
     */
    JsonResult<List<RepayOptRecord>> queryRepayOptRecords(String businessFlowNo);
}
