package cn.quantgroup.customer.service;

import cn.quantgroup.customer.rest.param.card.ModifyCardsQuery;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.card.CardResult;
import cn.quantgroup.customer.rest.vo.card.XyqbCardRelation;

import java.util.List;

/**
 * @author yangjun
 * @Date 2020/03/10 15:04:00
 * @Desc 银行卡相关
 */
public interface ICardService {
    /**
     * 查询绑卡信息
     * @param cardsQuery
     * @return
     */
    JsonResult<CardResult> queryCardLists(ModifyCardsQuery cardsQuery);

    /**
     * 查询卡关联信息
     * @param bankId
     * @return
     */
    JsonResult<List<XyqbCardRelation>> queryCardRelation(Long bankId);

    /**
     * 解绑
     * @param unBindCardModel
     * @return
     */
    JsonResult<String> unBindCardRelation(UnBindCardModel unBindCardModel);

    /**
     * 修改用户预留手机号
     * @param modifyReservePhone
     * @return
     */
    JsonResult<String> modifyReservePhone(ModifyReservePhone modifyReservePhone);
}
