package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */

@Slf4j
@RestController
@RequestMapping("/order")
public class OrderRest {



    @Autowired
    private IOrderService orderService;

    @GetMapping("/loan/{loanId}")
    public JsonResult getLoanOrderDetail(@PathVariable Long loanId){
        return orderService.getLoanOrderDetail(loanId);
    }

    @GetMapping("/flowchart/{orderNo}")
    public JsonResult getFlowChart(@PathVariable String orderNo){
        return orderService.findFlowChart(orderNo);
    }

    /**
     * 订单信息查询
     * @param orderQuery
     * @return
     */
    @GetMapping("/info")
    public JsonResult queryRepayInfo(OrderQueryParam orderQuery) {
        log.info("[查询订单信息],请求参数:orderQuery={}", orderQuery);
        return orderService.queryOrderInfo(orderQuery);
    }
}
