package cn.quantgroup.customer.repo;

import cn.quantgroup.customer.model.xyqbuser.BusinessType;
import cn.quantgroup.customer.model.xyqbuser.LoanProgress;
import cn.quantgroup.customer.model.xyqbuser.XyqbLoanApplicationHistory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Created by FrankChow on 15/7/23.
 */
public interface IXyqbLoanApplicationHistoryRepository extends JpaRepository<XyqbLoanApplicationHistory, Long> {

    XyqbLoanApplicationHistory findById(Long id);

    @Modifying
    @Query("UPDATE XyqbLoanApplicationHistory t SET t.progress = ?2 WHERE t.id = ?1")
    void updateLoanProgressById(Long id, LoanProgress loanProgress);

    @Modifying
    @Query("UPDATE XyqbLoanApplicationHistory t SET t.progress = ?2 , t.isActive= ?3 WHERE t.id = ?1")
    void updateLoanProgressByIdAndClose(Long id, LoanProgress loanProgress, Boolean isActive);

    List<XyqbLoanApplicationHistory> findByUserIdAndIsActive(Long userId, Boolean isActive);

    @Query("from  XyqbLoanApplicationHistory WHERE progress in ?1 and isActive = true")
    List<XyqbLoanApplicationHistory> findXyqbLoanApplicationHistoryByProgress(List<LoanProgress> loanProgresses);

    List<XyqbLoanApplicationHistory> findByUserId(Long userId);

    List<XyqbLoanApplicationHistory> findByUserIdAndBusinessType(Long userId, BusinessType businessType);

    List<XyqbLoanApplicationHistory> findByUserIdAndIsActiveAndBusinessType(Long userId, Boolean isActive, BusinessType businessType);
    @Modifying
    @Query("update XyqbLoanApplicationHistory apphis set apphis.progress = ?2 where apphis.id in ?1 ")
    void updateLoanProgressAfterFunding(Set<Long> loanIds, LoanProgress loanProgress);

    List<XyqbLoanApplicationHistory> findByUserIdAndChannelId(Long userId, Long channelId);

    XyqbLoanApplicationHistory findByUserIdAndChannelIdAndIsActive(Long userId, Long channelId, Boolean isActive);

    XyqbLoanApplicationHistory findByIdAndIsActiveTrue(Long loanId);

    List<XyqbLoanApplicationHistory> findByBusinessTypeAndUserId(BusinessType businessType, Long userId);

    @Query(value = "select * from loan_application_history where id in ?1",nativeQuery = true)
    List<XyqbLoanApplicationHistory> findObjectsByIds(List<Long> ids);

    @Query(nativeQuery = true, value = "SELECT count(DISTINCT h.id) FROM repay_notify_record n " +
            "LEFT JOIN loan_application_history h ON n.loan_id=h.id " +
            "WHERE n.fund_corp_id=?1 AND n.notice_type=1 AND n.notify_status=0 AND h.progress=16")
    Long countUnNotifyRecordByFundingCorp(Long fundingCorpId);

    @Query(nativeQuery = true, value = "SELECT DISTINCT h.* FROM repay_notify_record n " +
            "LEFT JOIN loan_application_history h ON n.loan_id=h.id " +
            "WHERE n.fund_corp_id=?1 AND n.notice_type=1 AND n.notify_status=0 AND h.progress=16 limit ?2,?3")
    List<XyqbLoanApplicationHistory> findUnNotifyRecordByFundingCorp(Long fundingCorpId, int start, int pageSize);

    /**
     * 根据loanId获取授信单号
     *
     * @param loanId
     * @return
     */
    @Query(value = "select order_no from loan_account_ext where loan_id =?1 limit 1", nativeQuery = true)
    String findOrderNoByLoanId(Long loanId);

    /**
     * 获取最新一条订单数据
     *
     * @param userId
     * @param businessType
     * @return
     */
    @Query(value = "select * from loan_application_history where user_id = ?1 and business_type = ?2 order by id desc limit 1", nativeQuery = true)
    XyqbLoanApplicationHistory findLatestByUserIdAndType(Long userId, Integer businessType);

    /**
     * 查询逾期未完成提现的订单
     * @param start
     * @param end
     * @return
     */
    @Query(value = "select id from loan_application_history where created_at>=?1 and created_at<?2 and progress = 24 and is_active = 1", nativeQuery = true)
    List<BigInteger> findOverdueData(Date start, Date end);

    /**
     * 关闭逾期未完成提现的订单
     * @param id
     */
    @Modifying
    @Query(value = "update loan_application_history apphis set apphis.is_active=0, apphis.progress = 12 where apphis.id =?1 and apphis.progress = 24", nativeQuery = true)
    void closeOverdueData(Long id);

    @Query(value = "select * from loan_application_history where user_id = ?1 and id = ?2", nativeQuery = true)
    List<XyqbLoanApplicationHistory> findByUserIdAndLoanId(Long userId, Long loanId);

    /**
     * 查询老的有效订单.
     * @param userId
     * @return
     */
    @Query(value = "select * from loan_application_history where user_id = ?1 and id < 101637467 and progress in (15,16) and business_type = 0", nativeQuery = true)
    List<XyqbLoanApplicationHistory> findActivedOldOrder(Long userId);

}
