package cn.quantgroup.customer.model.xyqbuser;
import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by springning on 15-7-21.
 */
@Entity
@Table(name = "loan_application_manifest_history", uniqueConstraints = @UniqueConstraint(columnNames = "loan_application_history_id"))
public class XyqbLoanApplicationManifestHistory implements Serializable {

  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  @Column(name = "user_id")
  private Long userId;

  @Column(name = "loan_application_history_id")
  private Long loanApplicationHistoryId;

  @Column(name = "contract_loan_amount")
  private BigDecimal contractLoanAmount;

  @Column(name = "contract_term")
  private Integer contractTerm;

  @Column(name = "service_fee_per_term")
  private BigDecimal serviceFeePerTerm;

  @Column(name = "one_time_service_fee")
  private BigDecimal oneTimeServiceFee;

  @Column(name = "monthly_interest_rate")
  private BigDecimal monthlyInterestRate;

  @Column(name = "total_repayment_amount")
  private BigDecimal totalRepaymentAmount;

  @Column(name = "monthly_repayment")
  private BigDecimal monthlyRepayment;

  @Column(name = "funding_corp_id")
  private Long fundingCorpId;

  @Column(name = "funding_corp_name")
  private String fundingCorpName;

  @Column(name = "real_loan_amount")
  private BigDecimal realLoanAmount;

  @Column(name = "transaction_status")
  private TransactionStatus transactionStatus;

  @Column(name = "remark")
  private String remark;

  @Column(name = "red_packet_strategy")
  private String redPacketStrategy;

  /**
   * 年利率
   */
  @Column(name = "annual_interest_rate")
  private BigDecimal annualInterestRate;

  @Column(name = "created_at")
  private Date createdAt;
  /**
   * 每期用户本息
   */
  @Column(name = "principal_and_interest_per_term")
  private BigDecimal principalAndInterestPerTerm;

  /**
   * 总共用户本息
   */
  @Column(name = "total_principal_and_interest")
  private BigDecimal totalPrincipalAndInterest;

  @Column(name = "company_income")
  private BigDecimal companyIncome;

  @Column(name = "loan_received_at")
  private Date loanReceivedAt;

  @Column(name = "loan_paid_at")
  private Date loanPaidAt;

  @Column(name = "product_id")
  private Long productId;

  @Column(name = "channel_id")
  private Long channelId;

  @Column(name = "transaction_flow_id")
  private Long transactionFlowId;

  public XyqbLoanApplicationManifestHistory(Long userId, Long loanApplicationHistoryId) {
    this.userId = userId;
    this.loanApplicationHistoryId = loanApplicationHistoryId;
  }

  public XyqbLoanApplicationManifestHistory() {
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public Long getLoanApplicationHistoryId() {
    return loanApplicationHistoryId;
  }

  public void setLoanApplicationHistoryId(Long loanApplicationHistoryId) {
    this.loanApplicationHistoryId = loanApplicationHistoryId;
  }

  public BigDecimal getContractLoanAmount() {
    return contractLoanAmount;
  }

  public void setContractLoanAmount(BigDecimal contractLoanAmount) {
    this.contractLoanAmount = contractLoanAmount;
  }

  public Integer getContractTerm() {
    return contractTerm;
  }

  public void setContractTerm(Integer contractTerm) {
    this.contractTerm = contractTerm;
  }

  public BigDecimal getServiceFeePerTerm() {
    return serviceFeePerTerm;
  }

  public void setServiceFeePerTerm(BigDecimal serviceFeePerTerm) {
    this.serviceFeePerTerm = serviceFeePerTerm;
  }

  public BigDecimal getOneTimeServiceFee() {
    return oneTimeServiceFee;
  }

  public void setOneTimeServiceFee(BigDecimal oneTimeServiceFee) {
    this.oneTimeServiceFee = oneTimeServiceFee;
  }

  public BigDecimal getMonthlyInterestRate() {
    return monthlyInterestRate;
  }

  public void setMonthlyInterestRate(BigDecimal monthlyInterestRate) {
    this.monthlyInterestRate = monthlyInterestRate;
  }

  public BigDecimal getTotalRepaymentAmount() {
    return totalRepaymentAmount;
  }

  public void setTotalRepaymentAmount(BigDecimal totalRepaymentAmount) {
    this.totalRepaymentAmount = totalRepaymentAmount;
  }

  public BigDecimal getMonthlyRepayment() {
    return monthlyRepayment;
  }

  public void setMonthlyRepayment(BigDecimal monthlyRepayment) {
    this.monthlyRepayment = monthlyRepayment;
  }

  public Long getFundingCorpId() {
    return fundingCorpId;
  }

  public void setFundingCorpId(Long fundingCorpId) {
    this.fundingCorpId = fundingCorpId;
  }

  public String getFundingCorpName() {
    return fundingCorpName;
  }

  public void setFundingCorpName(String fundingCorpName) {
    this.fundingCorpName = fundingCorpName;
  }

  public BigDecimal getRealLoanAmount() {
    return realLoanAmount;
  }

  public void setRealLoanAmount(BigDecimal realLoanAmount) {
    this.realLoanAmount = realLoanAmount;
  }

  public TransactionStatus getTransactionStatus() {
    return transactionStatus;
  }

  public void setTransactionStatus(TransactionStatus transactionStatus) {
    this.transactionStatus = transactionStatus;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public BigDecimal getAnnualInterestRate() {
    return annualInterestRate;
  }

  public void setAnnualInterestRate(BigDecimal annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  public Date getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(Date createdAt) {
    this.createdAt = createdAt;
  }

  public BigDecimal getPrincipalAndInterestPerTerm() {
    return principalAndInterestPerTerm;
  }

  public void setPrincipalAndInterestPerTerm(BigDecimal principalAndInterestPerTerm) {
    this.principalAndInterestPerTerm = principalAndInterestPerTerm;
  }

  public BigDecimal getTotalPrincipalAndInterest() {
    return totalPrincipalAndInterest;
  }

  public void setTotalPrincipalAndInterest(BigDecimal totalPrincipalAndInterest) {
    this.totalPrincipalAndInterest = totalPrincipalAndInterest;
  }

  public BigDecimal getCompanyIncome() {
    return companyIncome;
  }

  public void setCompanyIncome(BigDecimal companyIncome) {
    this.companyIncome = companyIncome;
  }

  public Date getLoanReceivedAt() {
    return loanReceivedAt;
  }

  public void setLoanReceivedAt(Date loanReceivedAt) {
    this.loanReceivedAt = loanReceivedAt;
  }

  public Date getLoanPaidAt() {
    return loanPaidAt;
  }

  public void setLoanPaidAt(Date loanPaidAt) {
    this.loanPaidAt = loanPaidAt;
  }

  public Long getProductId() {
    return productId;
  }

  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public Long getChannelId() {
    return channelId;
  }

  public void setChannelId(Long channelId) {
    this.channelId = channelId;
  }

  public Long getTransactionFlowId() {
    return transactionFlowId;
  }

  public void setTransactionFlowId(Long transactionFlowId) {
    this.transactionFlowId = transactionFlowId;
  }

  public String getRedPacketStrategy() {
    return redPacketStrategy;
  }

  public void setRedPacketStrategy(String redPacketStrategy) {
    this.redPacketStrategy = redPacketStrategy;
  }

  @Override
  public String toString() {
    final StringBuffer sb = new StringBuffer("XyqbLoanApplicationManifestHistory{");
    sb.append("annualInterestRate=").append(annualInterestRate);
    sb.append(", id=").append(id);
    sb.append(", userId=").append(userId);
    sb.append(", loanApplicationHistoryId=").append(loanApplicationHistoryId);
    sb.append(", contractLoanAmount=").append(contractLoanAmount);
    sb.append(", contractTerm=").append(contractTerm);
    sb.append(", serviceFeePerTerm=").append(serviceFeePerTerm);
    sb.append(", oneTimeServiceFee=").append(oneTimeServiceFee);
    sb.append(", monthlyInterestRate=").append(monthlyInterestRate);
    sb.append(", totalRepaymentAmount=").append(totalRepaymentAmount);
    sb.append(", monthlyRepayment=").append(monthlyRepayment);
    sb.append(", fundingCorpId=").append(fundingCorpId);
    sb.append(", fundingCorpName='").append(fundingCorpName).append('\'');
    sb.append(", realLoanAmount=").append(realLoanAmount);
    sb.append(", transactionStatus=").append(transactionStatus);
    sb.append(", remark='").append(remark).append('\'');
    sb.append(", redPacketStrategy='").append(redPacketStrategy).append('\'');
    sb.append(", createdAt=").append(createdAt);
    sb.append(", principalAndInterestPerTerm=").append(principalAndInterestPerTerm);
    sb.append(", totalPrincipalAndInterest=").append(totalPrincipalAndInterest);
    sb.append(", companyIncome=").append(companyIncome);
    sb.append(", loanReceivedAt=").append(loanReceivedAt);
    sb.append(", loanPaidAt=").append(loanPaidAt);
    sb.append(", productId=").append(productId);
    sb.append(", channelId=").append(channelId);
    sb.append(", transactionFlowId=").append(transactionFlowId);
    sb.append('}');
    return sb.toString();
  }
}
