package cn.quantgroup.customer.util;

import org.apache.commons.lang3.StringUtils;

/**
 * 脱敏工具类
 *
 * @author Wang Xiangwei
 * @version 2020/3/18
 */
public class DesensitizeUtil {
    /**
     * 保留前面几位
     *
     * @param str
     * @param index
     * @return
     */
    public static String left(String str, int index) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        String name = StringUtils.left(str, index);
        return StringUtils.rightPad(name, StringUtils.length(str), "*");
    }

    /**
     * 前面保留 index 位明文，后面保留 end 位明文,如：[身份证号] 110****58，前面保留3位明文，后面保留2位明文
     *
     * @param str
     * @param index
     * @param end
     * @return
     */
    public static String around(String str, int index, int end) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < index; i++) {
            sb.append("*");
        }
        return StringUtils.left(str, index).concat(StringUtils.removeStart(StringUtils.leftPad(StringUtils.right(str, end), StringUtils.length(str), "*"), sb.toString()));
    }

    /**
     * 保留后面几位 如手机号 *******5678
     *
     * @param str
     * @param end
     * @return
     */
    public static String right(String str, int end) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return StringUtils.leftPad(StringUtils.right(str, end), StringUtils.length(str), "*");
    }


    public static String phoneMark(String phoneNo) {
        if (StringUtils.isNotBlank(phoneNo)) {
            String start = StringUtils.substring(phoneNo, 0, 3);
            String end = StringUtils.substring(phoneNo, phoneNo.length() - 4, phoneNo.length());
            return start.concat("****").concat(end);
        }
        return "";
    }

    public static String idNoMark(String idNo){
        if(StringUtils.isBlank(idNo)){
            return "";
        }

        if(idNo.length() == 18){
            return around(idNo,6,4);
        }

        if(idNo.length() == 15){
            return around(idNo,6,3);
        }

        return right(idNo,4);
    }

    // 手机号码前三后四脱敏
    public static String mobileDesensitization(String mobile) {
        if (StringUtils.isEmpty(mobile) || (mobile.length() != 11)) {
            return mobile;
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    //身份证前三后四脱敏
    public static String idcardDesensitization(String idcard) {
        if (StringUtils.isEmpty(idcard) || (idcard.length() < 8)) {
            return idcard;
        }
        return idcard.replaceAll("(?<=\\w{3})\\w(?=\\w{4})", "*");
    }

    //护照前2后3位脱敏，护照一般为8或9位
    public static String idPassportDesensitization(String idPassport) {
        if (StringUtils.isEmpty(idPassport) || (idPassport.length() < 8)) {
            return idPassport;
        }
        return idPassport.substring(0, 2) + new String(new char[idPassport.length() - 5]).replace("\0", "*") + idPassport.substring(idPassport.length() - 3);
    }
}
