package cn.quantgroup.customer.rest;
import cn.quantgroup.customer.rest.param.transactionreceipt.TransactionReceiptRecordQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.transaction.*;
import cn.quantgroup.customer.service.ITransactionReceiptRecordService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping("/transactionReceiptRecord")
public class TransactionReceiptRecordRest {

    @Autowired
    private ITransactionReceiptRecordService transactionReceiptRecordService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * 根据筛选条件进行查询
     * @param query
     * @return
     */
    @RequestMapping("/orderQuery/query_page")
    @ResponseBody
    public JsonResult<Page<TransactionReceiptRecordVO>> queryPage(@RequestBody TransactionReceiptRecordQuery query) {
        if (query.getPageNo()== null || query.getPageNo() < 1) {
            log.error("[TransactionReceiptRecordRest_queryPage]查询参数pageNumber错误，pageNo={}", query.getPageNo());
            return JsonResult.buildErrorStateResult("查询参数pageNo错误");
        }
        Integer pageNo = query.getPageNo() - 1;
        query.setPageNo(pageNo);
        if (query.getPageSize() == null) {
            log.error("[workOrderRest_queryPage]查询参数pageSize错误，pageSize={}", query.getPageSize());
            return JsonResult.buildErrorStateResult("查询参数pageSize错误");
        }
        return transactionReceiptRecordService.findRecordsByQuery(query);
    }
    /**
     * 导入excel表格
     */
    @RequestMapping("/orderQuery/importTransactionReceiptRecord")
    @ResponseBody
    public JsonResult importTransactionReceiptRecord(@RequestParam("file") MultipartFile file) {
        try{
            return transactionReceiptRecordService.importTransactionReceiptRecord(file);
        }catch(Exception e){
            transactionReceiptRecordService.deleteRedis("importTransactionReceiptRecord");
            return JsonResult.buildErrorStateResult(e.getMessage());
        }
    }
    /**
     * 导出压缩包之前先校验
     */
    @RequestMapping("/orderQuery/checkCanExport")
    public JsonResult checkCanExport() {
        return transactionReceiptRecordService.checkCanExport();
    }

    /**
     * 后台更新交易凭证状态
     * @return
     */
    @RequestMapping("/orderQuery/updateTransactionRecordsStatus")
    @ResponseBody
    public JsonResult updateTransactionRecordsStatus() {
        return transactionReceiptRecordService.updateTransactionRecordsStatus();
    }

    //导出压缩包
    @RequestMapping("/orderQuery/exportTransactionZipFile")
    @ResponseBody
    public JsonResult exportTransactionZipFile(HttpServletRequest request, HttpServletResponse response) throws Exception{
        try{
            //transactionReceiptRecordService.deleteRedis("exportZipFile");
            String str = transactionReceiptRecordService.checkRedis("exportZipFile");
            if(StringUtils.isNotBlank(str)){
                return JsonResult.buildErrorStateResult("正在处理中，请稍后查看邮箱");
            }
            transactionReceiptRecordService.exportZipFile(request,response);
            return JsonResult.buildSuccessResult("请求已发送，请稍后查看邮箱",null);
        }catch(Exception e){
            transactionReceiptRecordService.deleteRedis("exportZipFile");
            return JsonResult.buildErrorStateResult(e.getMessage());
        }

    }

    @RequestMapping(value = "/orderQuery/checkRedis", method = RequestMethod.GET)
    public JsonResult redisTest(String type) {
        if(type.equals("1")){
            String str = transactionReceiptRecordService.checkRedis("importTransactionReceiptRecord");
            if(StringUtils.isNotBlank(str)){
                return JsonResult.buildErrorStateResult("只能一个人导入，当前有其他人正在导入，请稍后重试");
            }
        }else{
            String str = transactionReceiptRecordService.checkRedis("exportZipFile");
            if(StringUtils.isNotBlank(str)){
                return JsonResult.buildErrorStateResult("只能一个人导出，当前有其他人正在导出，请稍后重试");
            }
        }
        return JsonResult.buildSuccessResult("ok",null);
    }

}
