package cn.quantgroup.customer.moice.repo;
import cn.quantgroup.customer.moice.model.XyqbLoanApplicationManifestHistory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Created by root on 15-7-22.
 */
public interface IXyqbLoanApplicationManifestHistoryRepository extends
        JpaRepository<XyqbLoanApplicationManifestHistory, Long> {

    XyqbLoanApplicationManifestHistory findByLoanApplicationHistoryId(Long loanApplicationHistoryId);

    @Query("select new XyqbLoanApplicationManifestHistory(userId, max(loanApplicationHistoryId)) from XyqbLoanApplicationManifestHistory where userId in ?1 and channelId in ?2 and createdAt >= ?3 group by userId, channelId")
    List<XyqbLoanApplicationManifestHistory> findLoanAppManifestHistory(List<Long> userIdList, List<Long> channelIdList, Timestamp first);

    @Query("from XyqbLoanApplicationManifestHistory where loanApplicationHistoryId in ?1")
    List<XyqbLoanApplicationManifestHistory> findByLoanAppIds(List<Long> loanApplicationHistoryIdList);


    List<XyqbLoanApplicationManifestHistory> findByUserId(Long userId);

    @Query(value = "select loan_application_history_id from loan_application_manifest_history where id > ?!", nativeQuery = true)
    List<BigInteger> findByLoanIdApplyAfter410(Long beginId);


    @Query(value = "select * from loan_application_manifest_history where funding_corp_id = ?1 and transaction_status= 1 and loan_paid_at between ?2 and ?3", nativeQuery = true)
    List<XyqbLoanApplicationManifestHistory> findByCorpIdAndDate(Long corpId, Date startDate, Date endDate);

    /**
     * 查询已经放款的借款清单
     * @param corpId
     * @return
     */
    @Query(value = "select * from loan_application_manifest_history where funding_corp_id = ?1 and transaction_status= 2 and loan_paid_at between ?2 and ?3", nativeQuery = true)
    List<XyqbLoanApplicationManifestHistory> findPaiedByCorpIdAndDate(Long corpId, Date startDate, Date endDate);

    @Query(value = "select * from loan_application_manifest_history where loan_paid_at between ?1 and ?2", nativeQuery = true)
    List<XyqbLoanApplicationManifestHistory> findByDate(Date startDate, Date endDate);


    @Query(value = "select COUNT(m.id) from loan_application_manifest_history m JOIN loan_application_history l on m.loan_application_history_id = l.id where l.user_id = ?1 and  m.funding_corp_id = ?2 AND l.`is_active` = 1",nativeQuery = true)
    int findUserActiveOrderCount(Long userId, Long fundingCorpId);

    List<XyqbLoanApplicationManifestHistory> findByIdIn(Collection<Long> ids);

    @Query(value = "select * from loan_application_manifest_history where funding_corp_id in (780,770) and transaction_status in (2,5)  and DATE(loan_paid_at) = ?1", nativeQuery = true)
    List<XyqbLoanApplicationManifestHistory> findByLoanPaidAt(String loanPaidAt);

    @Query(value = "select * from loan_application_manifest_history where (user_id = ?1 or loan_application_history_id = ?2) and transaction_status in (0,1,4)", nativeQuery = true)
    List<XyqbLoanApplicationManifestHistory> findByUserIdOrLoanId(Long userId,Long loanId);
}
