package cn.quantgroup.customer.rest.param.mail;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.core.io.InputStreamSource;

import java.io.Serializable;

/**
 * Desc :
 * Date : 2017/9/28
 * Created with suntao
 */
@Data
@NoArgsConstructor
public class SendMailParam implements Serializable {

    private static final long serialVersionUID = -1L;

    private String subject;
    private String sender;
    private String[] receiver;
    private String[] copier;
    private String contentText;
    private String attachmentFileName;
    private InputStreamSource inputStreamSource;

    /**
     * 简单邮件参数
     * @param subject 主题
     * @param sender 发件人
     * @param receiver 收件人
     * @param copier 抄送人
     * @param contentText 内容
     */
    public SendMailParam(String subject, String sender, String[] receiver, String[] copier, String contentText) {
        this.subject = subject;
        this.sender = sender;
        this.receiver = receiver;
        this.copier = copier;
        this.contentText = contentText;
    }

    /**
     * 附件邮件参数
     * @param subject 主题
     * @param sender 发件人
     * @param receiver 收件人
     * @param copier 抄送人
     * @param contentText 内容
     * @param attachmentFileName 附件名称
     * @param inputStreamSource 附件流
     */
    public SendMailParam(String subject, String sender, String[] receiver, String[] copier, String contentText, String attachmentFileName, InputStreamSource inputStreamSource) {
        this.subject = subject;
        this.sender = sender;
        this.receiver = receiver;
        this.copier = copier;
        this.contentText = contentText;
        this.attachmentFileName = attachmentFileName;
        this.inputStreamSource = inputStreamSource;
    }
}
