package cn.quantgroup.customer.config.http.security;

import cn.quantgroup.customer.constant.Constant;
import cn.quantgroup.customer.util.PwdUtil;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;


@Component("passwordEncoder")
public class IPasswordEncoder implements PasswordEncoder {
    @Override
    public String encode(CharSequence rawPassword) {
        return PwdUtil.MD5(rawPassword.toString().toLowerCase() + Constant.PASSWORD_SALT);
    }

    @Override
    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return encodedPassword.equals(PwdUtil.MD5(rawPassword.toString().toLowerCase() + Constant.PASSWORD_SALT));
    }
}
