package cn.quantgroup.customer.entity;

import lombok.Getter;

@Getter
public enum Role {
 /*
                     | 初审|终审|统计|查询|催收|催收减免|修改订单状态
                     ———————————————
    管理员       |√      |√    |√     |√    |√    |x     |x
    主管          |√      |√    |√     |√    |√    |x    |x
    终审人员    |√      |√    |x     |√    |x     |x    |x
    初审人员    |√      |x    |x     |√    |x     |x    |x
    催收人员    |x      |x    |x     |x    |√     |x    |x
    催收主管    |x      |x    |x     |x    |√     |√    |x
    运营人员    |x      |x    |x     |x    |x     |x    |√
     */

    ADMINISTRATOR("管理员"),
    SUPERVISOR("主管"),
    FINAL_AUDITOR("终审人员"),
    FIRST_AUDITOR("初审人员"),
    CUSTOMER_SERVICE("客服人员"),
    DEBT_COLLECTOR("催收人员"),
    DEBT_SUPERVISOR("催收主管"),
    OPERATOR("运营人员");

    private String name;

    Role(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }

}
