package cn.quantgroup.customer.config.http.security;

import cn.quantgroup.customer.rest.JsonResult;
import org.apache.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import static cn.quantgroup.customer.constant.Constant.GSON;

public class RESTAuthenticationEntryPoint implements AuthenticationEntryPoint {

    private static final String UN_AUTHORIZED_RESULT = GSON.toJson(new JsonResult("UnAuthorized request", 401L, ""));

    @Override
    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException, ServletException {
        httpServletResponse.setStatus(HttpStatus.SC_UNAUTHORIZED);
        httpServletResponse.setContentType("application/javascript; charset=utf-8");
        PrintWriter out = httpServletResponse.getWriter();
        out.println(UN_AUTHORIZED_RESULT);
        out.close();
    }
}
