package cn.quantgroup.customer.config.http.mvc.converter;

import org.springframework.core.convert.converter.Converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;


public class DateConverter implements Converter<String, Date> {
    @Override
    public Date convert(String source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        return Date.from(Instant.from(LocalDate.parse(source).atStartOfDay().atZone(ZoneId.systemDefault())));
    }
}
