package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.order.*;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.param.applyorder.ApplyOrderQuery;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.card.XyqbCardRelation;
import cn.quantgroup.customer.rest.vo.card.XyqbCardsInfo;

import java.util.List;

public interface IXyqbService {
    String findRepayOrders(RepayOrderQuery repayOrderQuery);


    /**
     * 申请订单列表查询
     * @param applyOrderQuery
     * @return
     */
    JsonResult<List<ApplyOrder>> findApplyOrders(ApplyOrderQuery applyOrderQuery);

    /**
     * 流程日志查看
     * @param orderNo 申请订单号
     * @return
     */
    JsonResult<List<FlowNode>> findFlowChart(String orderNo);


    /**
     * 提现订单查询
     * @param loanId
     * @return
     */
    JsonResult<LoanOrder> findLoanOrder(Long loanId);

    /**
     * 还款计划
     * @param loanId
     * @return
     */
    JsonResult<OrderRepayment> repaymentPlanQuery(Long loanId);

    /**
     * 查询信用钱包返回用户绑卡列表信息
     * @param userId
     * @return
     */
    JsonResult<List<XyqbCardsInfo>> queryCardLists(Long userId);

    /**
     * 查询信用钱包卡关联信息
     * @param bankId
     * @return
     */
    JsonResult<List<XyqbCardRelation>> queryCardRelation(Long bankId);

    /**
     * 卡解绑
     * @param unBindCardModel
     * @return
     */
    JsonResult<String> unBindCardRelation(UnBindCardModel unBindCardModel);

    /**
     * 修改预留手机号
     * @param modifyReservePhone
     * @return
     */
    JsonResult<String> modifyReservePhone(ModifyReservePhone modifyReservePhone);

    String queryRepayInfo(RepayOrderInfoQuery repayOrderQuery);

    String queryRepayOptRecords(String businessFlowNo);

    /**
     * 订单状态查询
     *
     * @param orderQuery
     * @return
     */
    JsonResult<OrderStatus> orderStatusQuery(OrderQueryParam orderQuery);
}
