package cn.quantgroup.customer.exception;

import cn.quantgroup.customer.enums.ErrorCodeEnum;

public class BusinessException extends RuntimeException {

    private Long code;

    private ErrorCodeEnum type;

    public BusinessException() {
        super();
    }

    public BusinessException(ErrorCodeEnum type) {
        super(type.getMessage());
        this.code = type.getCode();
        this.type = type;
    }

    public BusinessException(Long code, String message) {
        super(message);
        this.code = code;
    }


    public BusinessException(String message) {
        super(message);
    }

    public Long getCode() {
        return code;
    }

    public ErrorCodeEnum getType() {
        return type;
    }
}
