package cn.quantgroup.customer.util;

import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.transaction.*;
import cn.quantgroup.customer.service.http.IHttpService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.*;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Description iTextPDFUtil
 * @className iTextPDFUtil
 **/
@Slf4j
public class ITextPDFUtil {
    public static final String FONT_FAMILY = "STSongStd-Light";
    private static IHttpService httpService;

    /**
     * @param table 表格
     * @param cell  列
     * @param text  文本
     * @return void
     * @Description 蓝色背景色标题内容行添加
     **/
    public static void addTableGroupTitle(PdfPTable table, PdfPCell cell, String text) {
        cell = new PdfPCell(new Phrase(getUTF8String(text), getColorFont(BaseColor.WHITE)));
        table.addCell(addTitleCell(cell, 25, new BaseColor(69, 153, 241), 2, false));
    }

    /**
     * @param table   表格
     * @param cell    列
     * @param text    文本
     * @param colspan 需要合并的列
     * @return void
     * @Description 蓝色背景色标题内容行添加
     **/
    public static void addTableGroupTitle(PdfPTable table, PdfPCell cell, String text, int colspan) {
        cell = new PdfPCell(new Phrase(getUTF8String(text), getColorFont(BaseColor.WHITE)));
        table.addCell(addTitleCell(cell, 25, new BaseColor(69, 153, 241), colspan, false));
    }

    /**
     * @param table       表格
     * @param cell        列
     * @param suggestText 核查建议内容
     * @param fontColor   核查建议内容文字颜色
     * @return com.itextpdf.text.Element
     * @Description 核查建议
     **/
    public static void addSuggestLine(PdfPTable table, PdfPCell cell, String suggestText, BaseColor fontColor) throws Exception {
        addSuggestLine(table, cell, suggestText, fontColor, 0, 10f, 30f);
    }

    /**
     * @param table       表格
     * @param cell        列
     * @param suggestText 核查建议内容
     * @param fontColor   核查建议内容文字颜色
     * @param colspan     合并的列
     * @param widths      列所占宽
     * @return com.itextpdf.text.Element
     * @Description 核查建议
     **/
    public static void addSuggestLine(PdfPTable table, PdfPCell cell, String suggestText, BaseColor fontColor, int colspan, float... widths) throws Exception {
        cell = new PdfPCell(new Phrase(getUTF8String("核查建议："), getColorFont()));
        cell.setColspan(1);
        table.addCell(addBaseCell(cell, 23, new BaseColor(238, 238, 238), false));
        cell = new PdfPCell(new Phrase(getUTF8String(suggestText), getColorFont(fontColor)));
        if (colspan > 0) {
            cell.setColspan(colspan);
        }
        table.addCell(addBaseCell(cell, 23, new BaseColor(238, 238, 238), false));
        table.setWidths(getColumnWiths(widths));
    }

    /**
     * @param groupText 文本内容
     * @return com.itextpdf.text.Element
     * @Description 信息分组table
     **/
    public static Element addTableGroupLine(String groupText) {
        PdfPTable tableBaseInfoIndex = new PdfPTable(1);
        tableBaseInfoIndex.setWidthPercentage(20);
        PdfPCell cellBaseInfo = new PdfPCell(new Phrase(getUTF8String(groupText), getColorFont(new BaseColor(0, 0, 0), 30, Font.BOLD)));
        cellBaseInfo.setHorizontalAlignment(Element.ALIGN_CENTER);
        tableBaseInfoIndex.addCell(addTitleCell(cellBaseInfo, 28, new BaseColor(255, 255, 255), 2, false));
        tableBaseInfoIndex.addCell(addBlankLine(10, 1));
        return tableBaseInfoIndex;
    }

    /**
     * @param color      字体颜色
     * @param fontSize   字体大小
     * @param fontFamily 字体
     * @return com.itextpdf.text.Font
     * @Description 指定颜色字体 默认处理中文显示
     **/
    public static Font getColorFont(BaseColor color, int fontSize, String fontFamily) {
        Font font = new Font(getFont());
        font.setColor(color);
        if (fontSize > 0 && (null != fontFamily || !"".equals(fontFamily))) {
            font.setSize(fontSize);
            font.setFamily(fontFamily);
        }
        return font;
    }

    /**
     * @param color    字体颜色
     * @param fontSize 字体大小
     * @param fontBold 字体加粗
     * @return com.itextpdf.text.Font
     * @Description 指定颜色字体 默认处理中文显示
     **/
    public static Font getColorFont(BaseColor color, int fontSize, int fontBold) {
        Font font = new Font(getFont());
        font.setSize(fontSize);
        font.setStyle(fontBold);
        font.setColor(color);
        return font;
    }

    /**
     * @param color 字体颜色
     * @return com.itextpdf.text.Font
     * @Description 指定颜色字体 默认处理中文显示
     **/
    public static Font getColorFont(BaseColor color) {
        return getColorFont(color, 0, null);
    }

    /**
     * @return com.itextpdf.text.Font
     * @Description 默认处理中文显示
     **/
    public static Font getColorFont() {
        Font font = new Font(getFont());
        return font;
    }

    /**
     * @param widths 一个或多个
     * @return float[]
     * @Description 指定列宽度
     **/
    public static float[] getColumnWiths(float... widths) {
        float[] columnWidths = new float[widths.length];
        for (int i = 0; i < widths.length; i++) {
            columnWidths[i] = widths[i];
        }
        return columnWidths;
    }

    /**
     * @param titleCell      要操作的cell
     * @param fixedHeight    行高度
     * @param baseColor      背景色
     * @param colspan        合并的列数
     * @param isBottomBorder 是否有下边框 true 有 fasle 没有
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加表头cell
     **/
    public static PdfPCell addTitleCell(PdfPCell titleCell, int fixedHeight, BaseColor baseColor, int colspan, boolean isBottomBorder) {
        titleCell.setColspan(colspan);
        titleCell.setMinimumHeight(fixedHeight);
        titleCell.setUseVariableBorders(true);
        titleCell.setUseAscender(true);
        titleCell.setUseDescender(true);
        titleCell.setBackgroundColor(baseColor);
        if (isBottomBorder) {
            titleCell.setBorderColor(BaseColor.LIGHT_GRAY);
        } else {
            titleCell.setBorder(Rectangle.NO_BORDER);
        }
        titleCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        return titleCell;
    }

    /**
     * @param fixedHeight 空行高度
     * @param colspan     合并的列数
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加空行
     **/
    public static PdfPCell addBlankLine(int fixedHeight, int colspan) {
        PdfPCell blankLine = new PdfPCell();
        blankLine.setMinimumHeight(fixedHeight);
        blankLine.setBorder(Rectangle.NO_BORDER);
        blankLine.setColspan(colspan);
        return blankLine;
    }

    /**
     * @param baseCell 要操作的cell
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加默认cell
     **/
    public static PdfPCell addBaseCell(PdfPCell baseCell, BaseColor backGroundColor) {
        baseCell.setMinimumHeight(23);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
//        baseCell.setBorder(Rectangle.);
        baseCell.setBackgroundColor(backGroundColor);
        baseCell.setBorderColor(BaseColor.LIGHT_GRAY);
        baseCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        return baseCell;
    }

    /**
     * @param baseCell 要操作的cell
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加默认cell
     **/
    public static PdfPCell addBaseCell(PdfPCell baseCell) {
        baseCell.setMinimumHeight(23);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
//        baseCell.setBorder(Rectangle.);
        baseCell.setBorderColor(BaseColor.LIGHT_GRAY);
        baseCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        return baseCell;
    }

    /**
     * @param baseCell       要操作的cell
     * @param isBottomBorder 是否有下边框 true 有 fasle 没有
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加cell
     **/
    public static PdfPCell addBaseCell(PdfPCell baseCell, boolean isBottomBorder) {
        baseCell.setMinimumHeight(23);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
        if (isBottomBorder) {
            baseCell.setBorderColor(BaseColor.LIGHT_GRAY);
        } else {
            baseCell.setBorder(Rectangle.NO_BORDER);
        }
        baseCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        return baseCell;
    }

    /**
     * @param baseCell       要操作的cell
     * @param fixedHeight    行高
     * @param color          背景色
     * @param isBottomBorder 是否有下边框 true 有 fasle 没有
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加cell
     **/
    public static PdfPCell addBaseCell(PdfPCell baseCell, int fixedHeight, BaseColor color, boolean isBottomBorder) {
        baseCell.setMinimumHeight(fixedHeight);
        baseCell.setUseVariableBorders(true);
        baseCell.setUseAscender(true);
        baseCell.setUseDescender(true);
        if (null != color) {
            baseCell.setBackgroundColor(color);
        }
        if (isBottomBorder) {
            baseCell.setBorderColor(BaseColor.LIGHT_GRAY);
        } else {
            baseCell.setBorder(Rectangle.NO_BORDER);
        }
        baseCell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
        return baseCell;
    }

    /**
     * @param value 填充的值
     * @param color 字体颜色
     * @param color 背景颜色
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initTitlePdfCell(String value, BaseColor color, BaseColor backGroundColor) {
        Font font = getColorFont(color);
        font.setStyle(Font.BOLD);
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), font));
        breakFithCell.setBackgroundColor(backGroundColor);
        return breakFithCell;
    }

    /**
     * @param value 填充的值
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initTitlePdfCell(String value) {
        Font font = getColorFont(new BaseColor(0, 0, 0));
        font.setStyle(Font.BOLD);
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), font));
        breakFithCell.setBackgroundColor(new BaseColor(195, 195, 195));
        return breakFithCell;
    }

    /**
     * @param value 填充的值
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initTitlePdfCell(String value, int fontSize) {
        Font font = getColorFont(new BaseColor(0, 0, 0));
        font.setSize(fontSize);
        font.setStyle(Font.BOLD);
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), font));
        breakFithCell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
        breakFithCell.setBackgroundColor(new BaseColor(195, 195, 195));
        return breakFithCell;
    }

    /**
     * @param value 填充的值
     * @param color 填充颜色
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initPhrasePdfCell(String value, BaseColor color) {
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), getColorFont(color)));
        return breakFithCell;
    }

    /**
     * @param value 填充的值
     * @param color 填充颜色
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initParagraphPdfCell(String value, BaseColor color) {
        PdfPCell breakFithCell = new PdfPCell(new Paragraph(getUTF8String(value), getColorFont(color)));
        return breakFithCell;
    }

    /**
     * @param value 填充的值
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initPhrasePdfCell(String value) {
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), getColorFont()));
        return breakFithCell;
    }

    /**
     * @param value    填充的值
     * @param fontSize 字体大小
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initPhrasePdfCell(String value, int fontSize) {
        Font font = getColorFont();
        font.setSize(fontSize);
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), font));
        return breakFithCell;
    }

    /**
     * @param value    填充的值
     * @param fontSize 字体大小
     * @return com.itextpdf.text.pdf.PdfPCell
     * @Description 添加数据、颜色
     **/
    public static PdfPCell initPhrasePdfCell(String value, int fontSize, int align) {
        Font font = getColorFont();
        font.setSize(fontSize);
        PdfPCell breakFithCell = new PdfPCell(new Phrase(getUTF8String(value), font));
        breakFithCell.setHorizontalAlignment(align);
        return breakFithCell;
    }

    /**
     * @return com.itextpdf.text.pdf.BaseFont
     * @Description 设置中文支持
     * @Author 小帅丶
     * @Date 2019/7/11 10:33
     * @Param []
     **/
    static BaseFont bf = null;

    public static BaseFont getFont() {
        try {
            if (bf == null) {
                // 这个是xmlworker提供的获取字体方法，很方便，对中文支持很好
                FontFactoryImp fp = new XMLWorkerFontProvider();
                // 注册指定的字体目录，默认构造方法中会注册全部目录，我这里注册了src/font目录
                fp.registerDirectory(ClassUtils.getDefaultClassLoader().getResource("").getPath().concat("fonts"), true);
//                log.info("预加载路径：{}看一下字体列表：{}", ClassUtils.getDefaultClassLoader().getResource("").getPath().concat("fonts"), JSON.toJSONString(fp));
                Font a = fp.getFont("宋体");
                bf = a.getBaseFont();
            }
        } catch (Exception e) {
            System.out.println("Exception = " + e.getMessage());
        }
        return bf;
    }

    /**
     * 斜角排列、全屏多个重复的花式文字水印
     *
     * @param input             需要加水印的PDF读取输入流
     * @param output            输出生成PDF的输出流
     * @param waterMarkString   水印字符
     * @param xAmout            x轴重复数量
     * @param yAmout            y轴重复数量
     * @param opacity           水印透明度
     * @param rotation          水印文字旋转角度，一般为45度角
     * @param waterMarkFontSize 水印字体大小
     * @param color             水印字体颜色
     */
    public static void stringWaterMark(InputStream input, OutputStream output, String waterMarkString, int xAmout, int yAmout, float opacity, float rotation, int waterMarkFontSize, BaseColor color) {
        try {

            PdfReader reader = new PdfReader(input);
            PdfStamper stamper = new PdfStamper(reader, output);

            BaseFont baseFont = getFont();

            int total = reader.getNumberOfPages() + 1;

            PdfContentByte over;
            // 给每一页加水印
            for (int i = 1; i < total; i++) {
                Rectangle pageRect = stamper.getReader().getPageSizeWithRotation(i);
                // 计算水印每个单位步长X,Y
                float x = pageRect.getWidth() / xAmout;
                float y = pageRect.getHeight() / yAmout;

                over = stamper.getOverContent(i);
                PdfGState gs = new PdfGState();
                // 设置透明度为
                gs.setFillOpacity(opacity);

                over.setGState(gs);
                over.saveState();

                over.beginText();
                over.setColorFill(color);
                over.setFontAndSize(baseFont, waterMarkFontSize);

                for (int n = 0; n < xAmout + 1; n++) {
                    for (int m = 0; m < yAmout + 1; m++) {
                        over.showTextAligned(Element.ALIGN_CENTER, waterMarkString, x * n, y * m, rotation);
                    }
                }

                over.endText();
            }
            stamper.close();
        } catch (Exception e) {
            new Exception("NetAnd PDF add Text Watermark error" + e.getMessage());
        }
    }

    /**
     * 图片水印，整张页面平铺
     *
     * @param input     需要加水印的PDF读取输入流
     * @param output    输出生成PDF的输出流
     * @param imageFile 水印图片路径
     */
    public static void imageWaterMark(InputStream input, OutputStream output, String imageFile, float opacity) {
        try {

            PdfReader reader = new PdfReader(input);
            PdfStamper stamper = new PdfStamper(reader, output);
            Rectangle pageRect = stamper.getReader().getPageSize(1);
            float w = pageRect.getWidth();
            float h = pageRect.getHeight();

            int total = reader.getNumberOfPages() + 1;

            Image image = Image.getInstance(imageFile);
            image.setAbsolutePosition(0, 0);// 坐标
            image.scaleAbsolute(w, h);

            PdfGState gs = new PdfGState();
            gs.setFillOpacity(opacity);// 设置透明度

            PdfContentByte over;
            // 给每一页加水印
            float x, y;
            Rectangle pagesize;
            for (int i = 1; i < total; i++) {
                pagesize = reader.getPageSizeWithRotation(i);
                x = (pagesize.getLeft() + pagesize.getRight()) / 2;
                y = (pagesize.getTop() + pagesize.getBottom()) / 2;
                over = stamper.getOverContent(i);
                over.setGState(gs);
                over.saveState();//没这个的话，图片透明度不起作用,必须在beginText之前，否则透明度不起作用，会被图片覆盖了内容而看不到文字了。
                over.beginText();
                // 添加水印图片
                over.addImage(image);
            }
            stamper.close();
        } catch (Exception e) {
            new Exception("NetAnd PDF add image Watermark error" + e.getMessage());
        }
    }

    /**
     * @param tableMobileHeader 要操作的表格
     * @param cellMobileHeader  要操作的单元格
     * @param clospan           合并列 不需要合并填写0
     * @param fixedHeight       行高
     * @param padding           间距
     * @param border            边框
     * @param borderColor       边框颜色
     * @param backgroundColor   背景色
     * @param vertical          垂直对齐方式
     * @param horizontal        水平对齐方式
     * @return void
     * @description 顶部表格卡片形式显示格式数据组装
     **/
    public static void addTableHeaderData(PdfPTable tableMobileHeader, PdfPCell cellMobileHeader, int clospan, float fixedHeight, int padding, int border, BaseColor borderColor, BaseColor backgroundColor, int vertical, int horizontal) {
        cellMobileHeader.setUseBorderPadding(true);
        cellMobileHeader.setUseAscender(true);
        if (clospan > 0) {
            cellMobileHeader.setColspan(clospan);
        }
        cellMobileHeader.setUseDescender(true);
        cellMobileHeader.setMinimumHeight(fixedHeight);
        cellMobileHeader.setPadding(padding);
        cellMobileHeader.setVerticalAlignment(vertical);
        cellMobileHeader.setHorizontalAlignment(horizontal);
        if (null != backgroundColor) {
            cellMobileHeader.setBackgroundColor(backgroundColor);
        }
        cellMobileHeader.setBorder(border);
        cellMobileHeader.setBorderColor(borderColor);
        tableMobileHeader.addCell(cellMobileHeader);
    }

    /**
     * @param tableMobileHeader 要操作的表格
     * @param cellMobileHeader  要操作的单元格
     * @param clospan           合并列 不需要合并填写0
     * @param backgroundColor   背景色
     * @return void
     * @description 顶部表格卡片形式显示格式数据组装
     **/
    public static void addTableHeaderData(PdfPTable tableMobileHeader, PdfPCell cellMobileHeader, int clospan, BaseColor backgroundColor) {
        addTableHeaderData(tableMobileHeader, cellMobileHeader, clospan, 100, 10, 30, BaseColor.WHITE, backgroundColor, 0, 0);
    }

    public static String getUTF8String(String string) {
        if (string != null) {
            try {
                return new String(string.getBytes(), "utf8");
            } catch (Exception e) {
                log.error("[getUTF8String]转换字符编码失败", e);
            }
        }
        return string;
    }

    public static void main(String[] args) {
        List<String>list =new ArrayList();
        list.add("D:\\交易凭证0222\\1王五");
        list.add("D:\\交易凭证0222\\1王二");
        list.add("D:\\交易凭证0222\\2里三");
        list.add("D:\\交易凭证0222\\2里斯");
        list.add("D:\\交易凭证0222\\3吴就");
        list.add("D:\\交易凭证0222\\3吴还");
        for(String str : list){
            FileToZip.mkdir(str);
            generatePDF(str+"\\"+20220222+".pdf");
        };
        //String str = "D:\\交易凭证0219\\1王五\\11.pdf";
        //generatePDF(str);

    }

    private static void generatePDF(String filePath){
        Document document = new Document(PageSize.A4);
        try {
            //PdfWriter.getInstance(document, new FileOutputStream("D:\\createSamplePDF.pdf"));
            PdfWriter.getInstance(document, new FileOutputStream(filePath));
            document.open();
            document.addTitle("交易凭证");//标题
            PdfPTable table = new PdfPTable(6);

            Font font = getColorFont(BaseColor.BLACK,7,"微软雅黑");
            //订单信息
            //第一行合并单元格
            PdfPCell cell;
            cell = new PdfPCell(new Phrase(getUTF8String("订单信息"), font));
            cell.setColspan(6);
            table.addCell(cell);
            //第二行标题
            table.addCell(new Phrase(getUTF8String("订单ID"), font));
            table.addCell(new Phrase(getUTF8String("供应商订单ID"), font));
            table.addCell(new Phrase(getUTF8String("供应链订单号"), font));
            table.addCell(new Phrase(getUTF8String("商品渠道"), font));
            table.addCell(new Phrase(getUTF8String("下单平台"), font));
            table.addCell(new Phrase(getUTF8String("平台账号id"), font));

            //第三行数据
            table.addCell(new Phrase(getUTF8String("123"), font));
            table.addCell(new Phrase(getUTF8String("456"), font));
            table.addCell(new Phrase(getUTF8String("789"), font));
            table.addCell(new Phrase(getUTF8String("000"), font));
            table.addCell(new Phrase(getUTF8String("111"), font));
            table.addCell(new Phrase(getUTF8String("222"), font));
            //第4行标题
            table.addCell(new Phrase(getUTF8String("平台绑定手机号"), font));
            table.addCell(new Phrase(getUTF8String("订单创建时间"), font));
            table.addCell(new Phrase(getUTF8String("支付完成时间"), font));
            table.addCell(new Phrase(getUTF8String("订单金额"), font));
            table.addCell(new Phrase(getUTF8String("实付金额"), font));
            table.addCell(new Phrase(getUTF8String("支付方式"), font));
            //第5行数据
            table.addCell(new Phrase(getUTF8String("123"), font));
            table.addCell(new Phrase(getUTF8String("456"), font));
            table.addCell(new Phrase(getUTF8String("789"), font));
            table.addCell(new Phrase(getUTF8String("000"), font));
            table.addCell(new Phrase(getUTF8String("111"), font));
            table.addCell(new Phrase(getUTF8String("222"), font));
            //物流信息
            cell = new PdfPCell(new Phrase(getUTF8String("物流信息"), font));
            cell.setColspan(6);
            table.addCell(cell);
            //第一行标题
            table.addCell(new Phrase(getUTF8String("发货时间"), font));
            table.addCell(new Phrase(getUTF8String("确认收货时间"), font));
            table.addCell(new Phrase(getUTF8String("订单状态"), font));
            table.addCell(new Phrase(getUTF8String("订单类型"), font));
            table.addCell(new Phrase(getUTF8String("物流公司"), font));
            table.addCell(new Phrase(getUTF8String("物流单号"), font));
            //第二行数据
            table.addCell(new Phrase(getUTF8String("123"), font));
            table.addCell(new Phrase(getUTF8String("456"), font));
            table.addCell(new Phrase(getUTF8String("789"), font));
            table.addCell(new Phrase(getUTF8String("000"), font));
            table.addCell(new Phrase(getUTF8String("111"), font));
            table.addCell(new Phrase(getUTF8String("222"), font));

            //商品信息
            cell = new PdfPCell(new Phrase(getUTF8String("商品信息"),font));
            cell.setColspan(6);
            table.addCell(cell);

            //商品信息标题
            //合并3行
            cell = new PdfPCell(new Phrase(getUTF8String("商品名称"), font));
            cell.setColspan(3);
            table.addCell(cell);
            //合并2行
            cell = new PdfPCell(new Phrase(getUTF8String("商品属性"), font));
            cell.setColspan(2);
            table.addCell(cell);
            table.addCell(new Phrase(getUTF8String("商品件数"), font));

            //商品信息数据
            cell = new PdfPCell(new Phrase(getUTF8String("元宵汤圆"), font));
            cell.setColspan(3);
            table.addCell(cell);

            cell = new PdfPCell(new Phrase(getUTF8String("黑芝麻"), font));
            cell.setColspan(2);
            table.addCell(cell);
            table.addCell(new Phrase(getUTF8String("3"), font));

            //收货人信息
            cell = new PdfPCell(new Phrase(getUTF8String("收货人信息"), font));
            cell.setColspan(6);
            table.addCell(cell);

            //收货人信息标题
            table.addCell(new Phrase(getUTF8String("收货人手机"), font));
            table.addCell(new Phrase(getUTF8String("收货人姓名"), font));
            cell = new PdfPCell(new Phrase(getUTF8String("收货地址"), font));
            cell.setColspan(4);
            table.addCell(cell);

            //收货人信息数据
            table.addCell(new Phrase(getUTF8String("18732195428"), font));
            table.addCell(new Phrase(getUTF8String("吴琼"), font));
            cell = new PdfPCell(new Phrase(getUTF8String("河北省石家庄市元氏县南佐镇"), font));
            cell.setColspan(4);
            table.addCell(cell);

            //物流详情
            cell = new PdfPCell(new Phrase(getUTF8String("物流详情"), font));
            cell.setColspan(6);
            table.addCell(cell);
            //物流详情标题
            table.addCell(new Phrase(getUTF8String("时间"), font));
            cell = new PdfPCell(new Phrase(getUTF8String("状态"), font));
            cell.setColspan(5);
            table.addCell(cell);

            //物流详情数据
            for(int i= 0;i <50;i++){
                table.addCell(new Phrase(getUTF8String("2022/01/10 10:50"), font));
                cell = new PdfPCell(new Phrase(getUTF8String("您的订单已由本人签收。如有疑问您可以联系配送员【陶威威，13157333133】确认。感谢您在京东购物，欢迎再次光临。"), font));
                cell.setColspan(5);
                table.addCell(cell);
            }

            document.add(table);
            document.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}