package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.aop.OperateLog;
import cn.quantgroup.customer.rest.param.ordermapping.OperateEntryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author yangjun
 * @Date 2020/4/17 15:57
 * @Desc 需要鉴权的功能
 * @Update
 */

@Slf4j
@RestController
@RequestMapping("/operate/sys")
public class OperateRest {
    @Autowired
    private IOrderService orderService;

    /**
     * 提前一次性结清订单白名单配置
     *
     * @param operateEntryParam
     * @return
     */
    @PostMapping("/setOrCancelEarlySettleUpWhiteLists")
    @OperateLog(moduleName = "提前一次性结清白名单操作")
    public JsonResult setOrCancelEarlySettleUpEntry(OperateEntryParam operateEntryParam) {
        log.info("[结清白名单设置操作],请求参数:operateEntryParam={}", operateEntryParam);
        return orderService.operateEntry(operateEntryParam);
    }
}
