package cn.quantgroup.customer.repo;

import cn.quantgroup.customer.entity.WorkOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface WorkOrderRepo extends JpaRepository<WorkOrder, Long> , JpaSpecificationExecutor<WorkOrder> {

    @Query(value = "select * from operate_log where loan_id =?1 and status = 1 ORDER BY created_at ASC", nativeQuery = true)
    List<WorkOrder> findbss(Long loanId);

    @Query(value = "select count(1) from operate_log where loan_id =?1 and status = 1", nativeQuery = true)
    Long findLogsCountsByLoanId(Long loanId);
}
