package cn.quantgroup.customer.model.order;

import cn.quantgroup.customer.enums.UserRepayType;
import cn.quantgroup.customer.util.DateUtil;
import cn.quantgroup.customer.util.MoneySerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class BaitRepaymentPlan {
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 商户号
     */
    private Integer merchantId;

    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 订单日期
     */
    private String orderTime;
    /**
     *订单金额
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal orderAmount;
    /**
     *订单期数
     */
    private String repayTermDesc;
    /**
     *订单状态
     */
    private String statusDesc;

    private List<BaitRepayPlan> baitRepayPlanList;


    public static BaitRepaymentPlan valueOf(BaitRepaymentPlanItem repaymentPlanItem) {

        if (repaymentPlanItem == null) {
            return null;
        }
        BaitRepaymentPlan repayment = new BaitRepaymentPlan();
        repayment.setOrderId(repaymentPlanItem.getOrderId());
        repayment.setOrderNo(repaymentPlanItem.getOrderNo());
        repayment.setOrderName(repaymentPlanItem.getOrderName());
        repayment.setMerchantId(repaymentPlanItem.getMerchantId());
        repayment.setOrderAmount(repaymentPlanItem.getOrderAmount());
        repayment.setRepayTermDesc(repaymentPlanItem.getRepayTermDesc());
        repayment.setStatusDesc(repaymentPlanItem.getStatusDesc());
        repayment.setOrderTime(repaymentPlanItem.getOrderTime());
        List<BaitRepayPlan> plans = repaymentPlanItem.getPlans();
        repayment.setBaitRepayPlanList(plans);
        return repayment;
    }
}
