package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.param.thirdworkorder.WorkOrderParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IThirdWorkOrderService;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @description: 三方系统工单查询
 * @create: 2024-03-25
 */
@Slf4j
@RestController
@RequestMapping("workOrder/third")
public class ThirdWorkOrderRest {

    @Autowired
    private IThirdWorkOrderService thirdWorkOrderService;

    @PostMapping("/list")
    public JsonResult list(@RequestBody WorkOrderParam param) {
        return thirdWorkOrderService.queryWorkOrder(param);
    }
    @PostMapping("/export")
    public JsonResult export(@RequestBody WorkOrderParam param,
//        @RequestHeader("account") String account,
//        @RequestHeader("qg-tenant-id") Integer tenantId
        HttpServletRequest request
    ) {
        String account = request.getHeader("account");
        String tenantId = request.getHeader("qg-tenant-id");
        return thirdWorkOrderService.export(param,account,Integer.parseInt(tenantId));
    }


}
