package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.param.card.ModifyCardsQuery;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.ICardService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @author yangjun
 * @Date 2020/3/9 10:40
 * @Desc 银行卡相关
 * @Update
 */
@Slf4j
@RestController
@RequestMapping("/bindcard")
public class CardRest {

    @Autowired
    private ICardService cardService;

    /**
     * 查询用户绑卡信息
     *
     * @param cardsQuery
     * @return
     */
    @GetMapping("/info")
    public JsonResult queryCardLists(ModifyCardsQuery cardsQuery) {
        log.info("[查询用户绑卡列表],请求参数:cardsQuery={}", cardsQuery);
        return cardService.queryCardLists(cardsQuery);
    }


    /**
     * 绑卡关系查询
     *
     * @param bankId
     * @return
     */
    @GetMapping("/relation/{bankId}")
    public JsonResult relation(@PathVariable Long bankId) {
        log.info("[绑卡关系查询],请求参数:bankId={}", bankId);
        return cardService.queryCardRelation(bankId);
    }


    /**
     * 解除绑定
     *
     * @param unBindCardModel
     * @return
     */
    @PostMapping("/unbind")
    public JsonResult unbind(UnBindCardModel unBindCardModel) {
        log.info("[解除绑定],请求参数:unBindCardModel={}", unBindCardModel);
        return cardService.unBindCardRelation(unBindCardModel);
    }

    /**
     * 修改预留手机号
     *
     * @param modifyReservePhone
     * @return
     */
    @PostMapping("/reservephone")
    public JsonResult modifyReservePhone(ModifyReservePhone modifyReservePhone) {
        log.info("[解除绑定],请求参数:modifyReservePhone={}", modifyReservePhone);
        return cardService.modifyReservePhone(modifyReservePhone);
    }
}
