package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.service.IXyqbService;
import cn.quantgroup.customer.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("xyqbService")
public class XyqbServiceImpl implements IXyqbService {

    @Value("${api.http}")
    private String xyqbSysUrl;

    private final IHttpService httpService;

    @Autowired
    public XyqbServiceImpl(IHttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public String findRepayOrders(RepayOrderQuery repayOrderQuery) {
        String phoneNo = repayOrderQuery.getPhoneNo();
        Long userId = repayOrderQuery.getUserId();
        String url = xyqbSysUrl + "/ex/repayment/repay_orders";
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotEmpty(phoneNo)) {
            param.put("phoneNo", phoneNo);
        }
        if (Objects.nonNull(userId)) {
            param.put("userId", userId);
        }
        String response = httpService.get(url, param);
        log.info("[xyqb][query repay orders ] param:{},请求业务系统返回值:{}", param, response);
        return response;
    }

    /**
     * 查询绑定卡列表
     *
     * @param userId
     * @return
     */
    @Override
    public String queryCardLists(Long userId) {
        String url = xyqbSysUrl + "/ex/inside/customer_sys/query/bankcard";
        Map<String, Object> param = new HashMap<>(4);
        if (Objects.nonNull(userId)) {
            param.put("userId", userId);
        }
        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[queryCardLists] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[queryCardLists] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }

    @Override
    public String queryCardRelation(Long bankId) {
        String url = xyqbSysUrl + "/ex/inside/customer_sys/query/cardrelation";
        Map<String, Object> param = new HashMap<>(4);
        if (Objects.nonNull(bankId)) {
            param.put("bankId", bankId);
        }

        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[queryCardRelation] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[queryCardRelation] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }

    @Override
    public String unBindCardRelation(UnBindCardModel unBindCardModel) {
        String url = xyqbSysUrl + "/ex/inside/customer_sys/unbundle/relation";
        Map<String, Object> param = new HashMap<>(4);
        Long userId = unBindCardModel.getUserId();
        Long bindCardRecordId = unBindCardModel.getBindCardRecordId();
        if (Objects.nonNull(bindCardRecordId)) {
            param.put("bindCardRecordId", bindCardRecordId);
        }
        if (Objects.nonNull(userId)) {
            param.put("userId", userId);
        }
        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[unBindCardRelation] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[unBindCardRelation] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }

    @Override
    public String modifyReservePhone(ModifyReservePhone modifyReservePhone) {
        String url = xyqbSysUrl + "/ex/inside/customer_sys/modify/reservedphone";
        Map<String, Object> param = new HashMap<>(8);
        Long userId = modifyReservePhone.getUserId();
        Long bankId = modifyReservePhone.getBankId();
        String phoneNo = modifyReservePhone.getPhoneNo();
        if (Objects.nonNull(bankId)) {
            param.put("bankId", bankId);
        }
        if (Objects.nonNull(userId)) {
            param.put("userId", userId);
        }
        if (StringUtils.isNotBlank(phoneNo)) {
            param.put("phoneNo", phoneNo);
        }

        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[modifyReservePhone] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[modifyReservePhone] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }


}
