package xiaoman;

import cn.quantgroup.customer.Bootstrap;
import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.model.workorder.WorkOrderVO;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.customer.util.DesensitizeUtil;
import cn.quantgroup.customer.util.JSONTools;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.domain.Page;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * @description:
 * @author:tao
 * @create: 2020-08-14 16:28
 */

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class, webEnvironment= SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class WorkOrderTest {

    @Autowired
    private IWorkOrderService workOrderService;
    @Autowired
    private  IHttpService httpService;

    @Test
    public void queryPage() {
        JsonResult<Page<WorkOrderVO>> pageJsonResult = workOrderService.queryWorkOrder(0, 10, "", WorkOrderStatus.CREATED);
        System.out.println(JSONTools.serialize(pageJsonResult));
    }

    @Test
    public void testUser (){
        String url ="https://passportapi-qa2.liangkebang.net/api/sync/listByUserIds?userIds=70356056,70356055";
        String result = httpService.get(url);
        JSONObject userJsonObject = JSONObject.parseObject(userResult);
        JSONObject userData = userJsonObject.getJSONObject("data");
    }

    public static void main(String[] args) {
        System.out.println(DesensitizeUtil.mobileDesensitization("13597778033"));
        System.out.println(DesensitizeUtil.idcardDesensitization("422802199007261711"));
    }

}
