package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.order.FlowNode;
import cn.quantgroup.customer.model.order.LoanOrderDetail;
import cn.quantgroup.customer.model.order.OrderInfo;
import cn.quantgroup.customer.model.order.OrderInfoVo;
import cn.quantgroup.customer.rest.param.ordermapping.EarlySettleUpOrderQueryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OperateEntryParam;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;

import java.util.List;

/**
 * @author Wang Xiangwei
 * @version 2020/3/10
 */
public interface IOrderService{

    /**
     * 查看流程图
     * @param applyOrderNo
     * @return
     */
    JsonResult<List<FlowNode>> findFlowChart(String applyOrderNo);


    JsonResult<LoanOrderDetail> getLoanOrderDetail(Long loanId);

    /**
     * 查询订单信息
     * @param orderQuery
     * @return
     */
    JsonResult<OrderInfoVo> queryOrderInfo(OrderQueryParam orderQuery);

    /**
     * 查询提前一次性结清订单信息
     * @param orderQuery
     * @return
     */
    JsonResult queryEarlySettleUpOrders(EarlySettleUpOrderQueryParam orderQuery);

    /**
     *  显示or隐藏操作
     * @param operateEntryParam
     * @return
     */
    JsonResult operateEntry(OperateEntryParam operateEntryParam);

    /**
     *  提前一次性结清金额试算
     * @param loanId
     * @return
     */
    JsonResult earlySettleUpTrial(Long loanId);

    /**
     * 查询操作日志
     * @param loanId
     * @return
     */
    JsonResult queryOperateLog(Long loanId);
}
