package cn.quantgroup.customer.aop;

import cn.quantgroup.customer.entity.OperateLogModel;
import cn.quantgroup.customer.service.IOperateLogService;
import cn.quantgroup.customer.util.DateUtil;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Objects;

/**
 * @author yangjun
 * @Date 2020/4/14 13:33
 * @Desc
 * @Update
 */
@Aspect
@Component
@Slf4j
public class OperateLogAspect {

    @Autowired
    private IOperateLogService operateLogService;

    @Pointcut("@annotation(cn.quantgroup.customer.aop.OperateLog)")
    public void operateLog() {
    }


    @Around(value = "operateLog()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String logPre = "OperateLogAspect.around";
        log.info("{} 进入切面", logPre);
        Object[] args = pjp.getArgs();
        log.info("{} 请求参数 {}", logPre,args);
        Object result =  pjp.proceed(args);
        log.info("{} 请求参数 {},返回结果 {} ", logPre,args,result);
        dealOperateLog(pjp,result);
        return result;

    }

    private void dealOperateLog(ProceedingJoinPoint pjp,Object result){
        String logPre = "OperateLogAspect.dealOperateLog";
        Object[] args = pjp.getArgs();
        StringBuffer reqStrBuffer = new StringBuffer();
        String userNo = null;
        String userName = null;
        for(Object obj:args){
            reqStrBuffer.append(String.valueOf(obj));
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(obj));
            if(Objects.nonNull(jsonObject)){
                if(jsonObject.containsKey("userNo")){
                    userNo = jsonObject.getString("userNo");
                }

                if(jsonObject.containsKey("userName")){
                    userName = jsonObject.getString("userName");
                }
            }
        }
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();
        OperateLog oplog = method.getAnnotation(OperateLog.class);
        log.info("{} 获得注解 oplog={}", logPre, oplog);
        String className = pjp.getTarget().getClass().getName().substring(pjp.getTarget().getClass().getName().lastIndexOf(".")+1);
        String methodName = method.getName();
        String moduleName = oplog.moduleName();
        String module = className.concat("|").concat(methodName);
        if(StringUtils.isBlank(moduleName)){
            // 类名 + 方法签名为  moduleName
            moduleName = module;
        }
        log.info("{} 处理结果:{}",logPre,String.valueOf(result));
        if(!StringUtils.isAnyBlank(userNo,userName)){
            return;
        }

        OperateLogModel model = OperateLogModel.builder()
                .userName(userName)
                .userNo(userNo)
                .module(module)
                .moduleName(moduleName)
                .request(reqStrBuffer.toString())
                .response(String.valueOf(result))
                .createdAt(DateUtil.getCurrentTimestamp())
                .build();

        operateLogService.saveOperateLog(model);
    }


}
