package cn.quantgroup.customer.repo.xyqb;

import cn.quantgroup.customer.model.xyqbuser.XyqbRepaymentPlan;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by FrankChow on 15/10/28.
 */
public interface IXyqbRepaymentRepository extends JpaRepository<XyqbRepaymentPlan, Long> {
    List<XyqbRepaymentPlan> findByLoanApplicationHistoryId(Long loanApplicationHistoryId);

    @Modifying
    @Query("UPDATE XyqbRepaymentPlan t SET t.collectionRelief = ?2 WHERE t.id = ?1 ")
    void updateCollectionReliefById(Long id, BigDecimal collectionRelief);

    List<XyqbRepaymentPlan> findByLoanApplicationHistoryIdOrderByTermNoAsc(Long loanApplicationHistoryId);


}
