package cn.quantgroup.customer.repo.xyqb;
import cn.quantgroup.customer.model.xyqbuser.FundingCorpEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 *
 * 2017.11.10
 * @author Feng
 */
public interface IFundingCorpRepository extends JpaRepository<FundingCorpEntity, Long> {

    /**
     * 查询  根据状态
     * @param b
     * @return
     */
    List<FundingCorpEntity> findByEnable(boolean b);

    @Query(value = "SELECT a.`product_type` FROM quota_product a WHERE a.`id` = ?1",nativeQuery = true)
    Integer findProductType(Long productId);

    @Query(value = "SELECT a.`product_desc` FROM quota_product a WHERE a.`id` = ?1",nativeQuery = true)
    String findProductDesc(Long productId);

    @Query(value = "SELECT `name` FROM channel WHERE id = ?1",nativeQuery = true)
    String findChannelName(Long channelId);

    @Transactional(transactionManager = "xyqbTransactionManager", rollbackFor = Exception.class)
    @Query(value = "update funding_corp set refuse_repay_times = ?2 where id = ?1",nativeQuery = true)
    @Modifying
    void updateToRepayTime(Long fundingCorpId, String time);
}