package cn.quantgroup.customer.model.xyqbuser;
import lombok.ToString;
import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * Created by wuq on 21/11/29.
 */
@Entity
@Table(name = "loan_application_history")
@ToString
public class XyqbLoanApplicationHistory implements Serializable {

  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  @Column(name = "user_id")
  private Long userId;

  @Column(name = "channel_id")
  private Long channelId;

  //false表示借款申请是无效的
  @Column(name = "is_active")
  private Boolean isActive = true;

  //贷款进度 默认是02
  @Column(name = "progress")
  private LoanProgress progress = LoanProgress.USER_AUTHENTICATION_INCOMPLETE;
  @Transient
  private String progressDesc;

  @Column(name = "pay_approach")
  private PayApproach payApproach;

  @Column(name = "bank_card_id")
  private Long bankCardId;

  @Column(name = "business_type")
  private BusinessType businessType;

  @Column(name = "baitiao_merchant_id")
  private Long baitiaoMerchantId;

  //创建时间
  @Column(name = "created_at")
  private Timestamp createdAt;

  @Column(name = "created_from")
  private Long createdFrom;

  @Column(name = "updated_at")
  private Timestamp updatedAt;



  public XyqbLoanApplicationHistory() {
  }

  public PayApproach getPayApproach() {
    return payApproach;
  }

  public void setPayApproach(PayApproach payApproach) {
    this.payApproach = payApproach;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public Long getChannelId() {
    return channelId;
  }

  public void setChannelId(Long channelId) {
    this.channelId = channelId;
  }

  public Timestamp getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(Timestamp createdAt) {
    this.createdAt = createdAt;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public LoanProgress getProgress() {
    return progress;
  }

  public void setProgress(LoanProgress progress) {
    this.progress = progress;
  }

  public Long getBankCardId() {
    return bankCardId;
  }

  public void setBankCardId(Long bankCardId) {
    this.bankCardId = bankCardId;
  }

  public Long getCreatedFrom() {
    return createdFrom;
  }

  public void setCreatedFrom(Long createdFrom) {
    this.createdFrom = createdFrom;
  }

  public BusinessType getBusinessType() {
    return businessType;
  }

  public void setBusinessType(BusinessType businessType) {
    this.businessType = businessType;
  }

  public long parseChannelId() {
    return !Objects.equals(createdFrom, -1L) ? this.createdFrom : this.channelId;
  }

  public Long getBaitiaoMerchantId() {
    return baitiaoMerchantId;
  }

  public void setBaitiaoMerchantId(Long baitiaoMerchantId) {
    this.baitiaoMerchantId = baitiaoMerchantId;
  }

  public Boolean getActive() {
    return isActive;
  }

  public void setActive(Boolean active) {
    isActive = active;
  }

  public String getProgressDesc() {
    if (progress != null) {
      return progress.getDescription();
    }
    return progressDesc;
  }

  public void setProgressDesc(String progressDesc) {
    this.progressDesc = progressDesc;
  }

  public Timestamp getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Timestamp updatedAt) {
    this.updatedAt = updatedAt;
  }
}
