package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IRepayService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static cn.quantgroup.customer.constant.Constant.GSON;

@Slf4j
@RestController
@RequestMapping("/repay")
public class RepayRest {

    private final IRepayService repayService;

    @Autowired
    public RepayRest(IRepayService repayService) {
        this.repayService = repayService;
    }

    @GetMapping("/repayment/repay_orders")
    public JsonResult repayOrders(String phoneNo, String idNo) {
        if (StringUtils.isEmpty(phoneNo) && StringUtils.isEmpty(idNo)) {
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PARAM_ERROR.getMessage(), ErrorCodeEnum.PARAM_ERROR.getCode());
        }
        RepayOrderQuery repayOrderQuery = new RepayOrderQuery();
        repayOrderQuery.setPhoneNo(phoneNo);
        repayOrderQuery.setIdNo(idNo);
        String response = repayService.findRepayOrders(repayOrderQuery);
        return GSON.fromJson(response, JsonResult.class);
    }
}
