package cn.quantgroup.customer.enums;

public enum VccRepayStatusEnum {
    /**
     * 正常状态，主要包括：还款计划未出账、额度状态正常
     */
    Normal("正常"),

    /**
     * 还款状态，主要包括：账单待还款、还款计划待还款
     * 韩伟：待还款，生成账单后
     */
    Repay("还款"),
    /**
     * 逾期状态，主要包括：账单逾期、还款计划逾期
     */
    Overdue("逾期"),

    /**
     * 完结状态，主要包括：账单还清、还款计划还清、分期交易还清
     */
    Finish("完结"),
    /**
     * 完成状态， 主要包括：交易完成
     */
    Complete("完成");

    private String desc;
    private VccRepayStatusEnum(String desc){
        this.desc = desc;
    }


    public static String getDescByValue(String value){
        for (VccRepayStatusEnum statusEnum:VccRepayStatusEnum.values()){
            if (statusEnum.toString().equals(value)){
                return statusEnum.desc;
            }
        }
        return "";
    }
}
