package cn.quantgroup.customer.service.ftp;

import cn.quantgroup.customer.model.ftp.FileInfo;
import cn.quantgroup.customer.model.ftp.ServerInfo;
import org.apache.commons.lang3.NotImplementedException;

import java.io.IOException;
import java.util.List;

public interface IFtpService {
    Object send(Object request);

    /**
     * @param request   请求参数对象
     * @param retryTime 上传失败重试次数
     * @return ture:上传成功，false:上传失败
     * @throws Exception
     */
    default Boolean send(Object request, int retryTime) throws Exception {
        throw new NotImplementedException("send(Object request,int retryTime)方法没有实现！");
    }

    /**
     * 文件下载
     *
     * @param fileName
     * @return
     * @throws IOException
     */
    default byte[] down(String fileName) throws IOException {
        throw new NotImplementedException("文件下载没有实现！");
    }

    /**
     * SFTP　方式文件上传
     *
     * @param fileInfo   　文件信息
     * @param serverInfo 　SFTP服务器信息
     * @param retryTime  重试次数
     * @return
     * @throws Exception
     */
    default boolean send(FileInfo fileInfo, ServerInfo serverInfo, int retryTime) throws Exception {
        throw new NotImplementedException("send没有实现！");
    }

    /**
     * 文件下载
     *
     * @param fullName   路径文件名称
     * @param serverInfo 服务器信息
     * @param retryTime  重试次数
     * @return
     * @throws Exception
     */
    default byte[] down(String fullName, ServerInfo serverInfo, int retryTime) throws Exception {
        throw new NotImplementedException("文件下载没有实现！");
    }

    /**
     * 获取文件名列表
     *
     * @param serverInfo
     * @return
     * @throws Exception
     */
    default List<String> listDirectory(ServerInfo serverInfo) throws Exception {
        throw new NotImplementedException("查看目录下的所有文件没有实现！");
    }

}
