package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.entity.WorkOrder;
import cn.quantgroup.customer.model.workorder.WorkOrderVO;
import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.model.workorder.WorlOrderPriority;
import cn.quantgroup.customer.repo.WorkOrderRepo;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.customer.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author:tao
 * @create: 2020-08-14 15:24
 */
@Slf4j
@Service
public class WorkOrderServiceImpl implements IWorkOrderService {

    @Autowired
    private WorkOrderRepo workOrderRepo;

    @Override
    public void importData(List<WorkOrderVO> list) {

        int pageSize = 10000;

        // 总页数
        int pages = list.size() / pageSize;

        int mo = list.size() % pageSize;
        if (mo > 0) {
            pages++;
        }
        for (int currentPage = 0; currentPage < pages; currentPage++) {

            List<WorkOrder> workOrders = new ArrayList<>();

            for (int i = currentPage * pageSize; i < Math.min(list.size(), (currentPage + 1) * pageSize); i++) {
                // 0=> [0,10000)
                // 1=> [10000,20000)
                final WorkOrderVO woe = list.get(i);
                WorkOrder workOrder = new WorkOrder();
                workOrder.setWorkOrderId(Long.valueOf(woe.getWorkOrderId()));
                workOrder.setUserName(woe.getUserName());
                workOrder.setPhone(woe.getPhone());
                workOrder.setSubject(woe.getSubject());
                workOrder.setFrom(woe.getFrom());
                workOrder.setType1(woe.getType1());
                workOrder.setType2(woe.getType2());
                workOrder.setType3(woe.getType3());
                workOrder.setPriority(WorlOrderPriority.getWorlOrderPriority(woe.getPriority()));
                workOrder.setStatus(WorkOrderStatus.getWorkOrderStatus(woe.getStatus()));
                workOrder.setCreateUsername(woe.getCreateUsername());
                workOrder.setOpUsername(woe.getOpUsername());
                workOrder.setDurationTimes(Integer.valueOf(woe.getDurationTimes()));
                workOrder.setDuration(Integer.valueOf(woe.getDuration()));
                workOrder.setCreatedAt(DateUtil.stringToTimestamp(woe.getCreatedAt()));
                workOrder.setOpAt(DateUtil.stringToTimestamp(woe.getOpAt()));
                workOrder.setUpdatedAt(DateUtil.getCurrentTimestamp());
                workOrder.setRemark(woe.getRemark());
                workOrders.add(workOrder);
            }
            workOrderRepo.save(workOrders);
        }
        log.info("导入完成");
    }

    @Override
    public JsonResult<Page<WorkOrderVO>> queryWorkOrder(Integer pageNumber, Integer pageSize, String phone, WorkOrderStatus status) {
        Page<WorkOrder> page = workOrderRepo.findAll((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            // 指定渠道号
            if (Objects.nonNull(status)) {
                predicates.add(criteriaBuilder.equal(root.get("status"), status.ordinal()));
            }
            if (StringUtils.isNotEmpty(phone)) {
                predicates.add(criteriaBuilder.equal(root.get("phone"), phone));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        Page<WorkOrderVO> map = page.map(it -> {
            WorkOrderVO workOrderVO = new WorkOrderVO();
            workOrderVO.setWorkOrderId(it.getWorkOrderId() + "");
            workOrderVO.setUserName(it.getUserName());
            workOrderVO.setPhone(it.getPhone());
            workOrderVO.setSubject(it.getSubject());
            workOrderVO.setFrom(it.getFrom());
            workOrderVO.setType1(it.getType1());
            workOrderVO.setType2(it.getType2());
            workOrderVO.setType3(it.getType3());
            workOrderVO.setPriority(it.getPriority().getDesc());
            workOrderVO.setStatus(it.getStatus().getDesc());
            workOrderVO.setCreateUsername(it.getCreateUsername());
            workOrderVO.setOpUsername(it.getOpUsername());
            workOrderVO.setDurationTimes(it.getDurationTimes() + "");
            workOrderVO.setDuration(it.getDuration() + "");
            workOrderVO.setCreatedAt(it.getCreatedAt() == null ? "" : DateUtil.format(it.getCreatedAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setOpAt(it.getOpAt() == null ? "" : DateUtil.format(it.getOpAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setUpdatedAt(it.getUpdatedAt() == null ? "" : DateUtil.format(it.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setRemark(it.getRemark());
            return workOrderVO;
        });
        if (map != null) {
            return JsonResult.buildSuccessResult("success", map);
        } else {
            return JsonResult.buildErrorStateResult("查询失败");
        }
    }
}
