package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.model.kaordermapping.LoanOrderMapping;
import cn.quantgroup.customer.model.order.FlowNode;
import cn.quantgroup.customer.rest.param.ordermapping.OrderMappingQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IKaService;
import cn.quantgroup.customer.service.IOrderService;
import cn.quantgroup.customer.service.IXyqbService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author Wang Xiangwei
 * @version 2020/3/10
 */
@Slf4j
@Service
public class OrderServiceImpl implements IOrderService {
    @Autowired
    private IKaService kaService;

    @Autowired
    private IXyqbService xyqbService;

    @Override
    public JsonResult<List<FlowNode>> findFlowChart(String applyOrderNo) {
        String logPre = "OrderServiceImpl.findFlowChart";
        log.info("{} 查询流程图 applyOrderNo={}", logPre, applyOrderNo);
        OrderMappingQueryParam param = new OrderMappingQueryParam();
        param.setApplyOrderNo(applyOrderNo);
        JsonResult<LoanOrderMapping> orderMappingResult = kaService.findOrderMapping(param);
        LoanOrderMapping head = null;
        if (orderMappingResult.isSuccess()) {
            head = orderMappingResult.getData();
            log.info("{},申请订单号查询orderMapping applyOrderNo={},data={}", logPre, applyOrderNo, head);
        }

        JsonResult<List<FlowNode>> flowChart = xyqbService.findFlowChart(applyOrderNo);
        if (!flowChart.isSuccess()) {
            return flowChart;
        }

        List<FlowNode> flowNodeList = flowChart.getData();
        if (!Objects.isNull(head)) {
            FlowNode flowNode = new FlowNode();
            flowNode.setName("渠道用户信息导入");
            flowNode.setStatus(1);
            flowNode.setNode(head.getId().toString());
            flowNodeList.add(0, flowNode);
        }

        return JsonResult.buildSuccessResult("", flowNodeList);
    }
}
