package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.order.ApplyOrder;
import cn.quantgroup.customer.model.order.FlowNode;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.param.applyorder.ApplyOrderQuery;
import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.param.repay.RepayOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;

import java.util.List;

public interface IXyqbService {
    String findRepayOrders(RepayOrderQuery repayOrderQuery);


    /**
     * 申请订单列表查询
     * @param applyOrderQuery
     * @return
     */
    JsonResult<List<ApplyOrder>> findApplyOrders(ApplyOrderQuery applyOrderQuery);

    /**
     * 流程日志查看
     * @param orderNo 申请订单号
     * @return
     */
    JsonResult<List<FlowNode>> findFlowChart(String orderNo);


    /**
     * 提现订单查询
     * @param loanId
     * @return
     */
    JsonResult findLoanDetail(Long loanId);

    String queryCardLists(Long userId);

    String queryCardRelation(Long bankId);

    String unBindCardRelation(UnBindCardModel unBindCardModel);

    String modifyReservePhone(ModifyReservePhone modifyReservePhone);

    String queryRepayInfo(RepayOrderInfoQuery repayOrderQuery);

    String queryRepayOptRecords(String businessFlowNo);
}
