package cn.quantgroup.customer.rest.param.vcc;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

@Data
public class OfflineRepaySubmitParam {
    private String uniqueId;
    private List<ApplyBill> list;
    private Integer currTerm;
    @NotNull
    private BigDecimal amount;
    @NotNull
    private BigDecimal actualAmount;
    @NotNull
    @DateTimeFormat
    private Date actualDate;
    @NotBlank
    private String transNo;
    @NotBlank
    private String receiveAccount;
    @NotBlank
    private String receiveAccountName;
    @NotEmpty
    private List<String> credentialsAddress;
    private String mark;
    @NotNull
    private Integer repayType;
    @NotBlank
    private String name;
    @NotBlank
    private String phone;
    @NotBlank
    private String idNo;
    @NotBlank
    private String repayStatus;
    @NotNull
    private Integer userId;
}
