package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @description: 工单查询
 * @Author:tao
 * @create: 2020-08-13 15:57
 */
@Slf4j
@RestController
@RequestMapping("work_order")
public class WorkOrderRest {

    @Autowired
    private IWorkOrderService workOrderService;

    @GetMapping("query_page")
    public JsonResult queryPage(Integer pageNumber, Integer pageSize, String phone, String status) {
        if (pageNumber == null || pageNumber < 1) {
            log.error("[workOrderRest_queryPage]查询参数pageNumber错误，pageNumber={}", pageNumber);
            return JsonResult.buildErrorStateResult("查询参数pageNumber错误");
        }
        pageNumber = pageNumber - 1;
        if (pageSize == null) {
            log.error("[workOrderRest_queryPage]查询参数pageSize错误，pageSize={}", pageSize);
            return JsonResult.buildErrorStateResult("查询参数pageSize错误");
        }
        WorkOrderStatus statusEnum = null;
        if (StringUtils.isNotEmpty(status)) {
            try {
                statusEnum = WorkOrderStatus.valueOf(status);
            } catch (IllegalArgumentException e) {
                log.error("[workOrderRest_queryPage]查询参数status错误，status={}, e={}", status, ExceptionUtils.getStackTrace(e));
                return JsonResult.buildErrorStateResult("查询参数status错误");
            }
        }
        log.info("[workOrderRest_queryPage]查询成功phone={}", phone);
        return workOrderService.queryWorkOrder(pageNumber, pageSize, phone, statusEnum);
    }


}
