package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.rest.param.thirdworkorder.WorkOrderParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IThirdWorkOrderService;
import cn.quantgroup.customer.service.IWorkOrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @description: 三方系统工单查询
 * @create: 2024-03-25
 */
@Slf4j
@RestController
@RequestMapping("workOrder/third")
public class ThirdWorkOrderRest {

    @Autowired
    private IThirdWorkOrderService thirdWorkOrderService;

    @PostMapping("/list")
    public JsonResult list(@RequestBody WorkOrderParam param) {
        return thirdWorkOrderService.queryWorkOrder(param);
    }


}
