package cn.quantgroup.customer.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import lombok.Getter;

@Getter
public enum ProblemTypeEnum {

    PRODUCT_CONSULTATION(224, "商品咨询"),
    SHIPPING_CONSULTATION(225, "发货咨询"),
    REFUND_CONSULTATION(226, "退款咨询"),
    LOGISTICS_CONSULTATION(227, "物流咨询"),
    INVOICE_CONSULTATION(228, "发票咨询"),
    RESET_PASSWORD(253, "重置密码"),
    CANCEL_ACCOUNT(254, "注销账户"),
    PAYMENT_ISSUE(255, "支付问题"),
    MEMBERSHIP_CONSULTATION(257, "会员咨询"),
    CHANGE_PHONE_NUMBER(258, "修改手机号"),
    MERCHANT_REGISTRATION(259, "商家入驻"),
    SPECIAL_GROUP_CALL(260, "特殊人群来电"),
    //售前-其他
    PRE_SALE_OTHER(261, "其他"),
    REGISTER_ACCOUNT(269, "注册账号"),
    WALLET_ISSUE(294, "卡包问题"),
    TEST_USAGE(408, "测试使用"),


    /*售中*/
    URGE_SHIPMENT(231, "催促发货"),
    URGE_REFUND(232, "催退款"),
    NO_LOGISTICS_PROGRESS(233, "物流无进度"),
    CHANGE_ADDRESS(234, "更改地址"),
    //售中-其他
    MIDDLE_SALES_OTHER(235, "其他"),
    MIDDLE_SALES_PAYMENT_ISSUE(252, "支付问题"),
    LOGISTICS_INTERCEPTION_REJECTION(262, "物流拦截/拒收"),
    LOGISTICS_EXCEPTION(263, "物流异常"),
    CONSULT_SHIPMENT_TIMELINESS(266, "咨询发货时效"),
    CANCEL_ORDER(267, "取消订单"),
    GIFT_CARD_CONSULTATION(384, "礼品卡咨询"),
    EXCHANGE_GOODS(388, "换货"),
    URGE_SHIPMENT_WITHIN_48H(391, "48H内催促发货"),
    URGE_SHIPMENT_BEYOND_48H(392, "超48H催促发货"),
    URGE_SHIPMENT_WITHIN_72H(393, "72H内催促发货"),
    URGE_SHIPMENT_BEYOND_72H(394, "超72H催促发货"),
    URGE_COLLECTION(395, "催揽收（催促发货）"),
    URGE_CANCEL_ORDER_REVIEW_WITHIN_TIMELINESS(396, "时效内催取消订单审核"),
    URGE_CANCEL_ORDER_REVIEW_BEYOND_TIMELINESS(397, "超时催取消订单审核"),
    URGE_REFUND_REVIEW_WITHIN_TIMELINESS(400, "时效内催仅退款审核"),
    URGE_REFUND_REVIEW_BEYOND_TIMELINESS(401, "超时催仅退款审核"),

    /*售后*/
    RETURN_REFUND(237, "退货退款"),
    PRODUCT_QUALITY_ISSUE(238, "商品质量问题"),
    SHORTAGE_IN_DELIVERY(239, "漏发/少发"),
    LOST_DAMAGED_ITEM(240, "丢件/破损"),
    SHIPPING_COST_REIMBURSEMENT(241, "补运费"),
    COMPENSATION(242, "赔付"),
    AFTER_SLAES_URGE_REFUND(243, "催退款"),
    AFTER_SLAES_INVOICE_CONSULTATION(249, "发票咨询"),
    OTHER(250, "其他"),
    INSTALLATION_ISSUE(251, "安装问题"),
    WRONG_ITEM_DELIVERED(264, "商品错发"),
    PRICING_ISSUE(265, "价格问题"),
    SUSPECTED_FAKE_PRODUCT(268, "质疑假货"),
    EXCHANGE_ISSUE(390, "换货问题"),
    URGE_AFTERSALES_REVIEW_WITHIN_TIMELINESS(399, "时效内催售后审核"),
    URGE_AFTERSALES_REVIEW_BEYOND_TIMELINESS(402, "超时催售后审核"),
    URGE_REFUND_REVIEW(403, "催退款审核"),
    MAX_MEMBER_REFUND(405, "MAX会员退费"),
    DIAMOND_MEMBER_REFUND(411, "钻石会员退费"),
    LOGISTICS_UPLOAD_ERROR(412, "物流上传错误"),
    TEST(410, "测试"),

    /*投诉错误*/
    COMPLAINT_ERROR(435, "投诉错误"),
    /*卡包业务*/
    CARD_BUSINESS(437, "卡包业务"),

    /*电商订单业务*/
    URGE_DELIVERY_WITHIN_TIME(439, "催发货-时效内"),
    URGE_DELIVERY_OVERDUE(440, "催发货-超时效"),
    URGE_REFUND_WITHIN_TIME(441, "催退款-时效内"),
    URGE_REFUND_OVERDUE(442, "催退款-超时效"),
    INTERCEPT_RETURN_OR_CANCEL(443, "拦截退回/取消拦截"),
    MODIFY_ADDRESS_OR_INFO(444, "改地址/改信息"),
    AFTER_SALES_ISSUE(445, "商品售后问题"),
    WRONG_MISSING_DAMAGE(446, "错发/漏发/少发/破损"),
    CANCEL_ORDER_447(447, "取消订单"),
    SERVICE_COMPLAINT(448, "服务不满投诉"),
    OTHER_CONSULTATION_TYPE(449, "其他咨询类型"),
    PRE_SALE_CONSULTATION(458, "售前问题咨询"),
    MEMBER_REFUND_ISSUE(459, "会员退费问题"),
    OTHER_LOGISTICS_ISSUE(460, "其他物流问题"),
    EMPTY_PACKAGE(462, "空包裹"),


    /*账号业务*/
    CANCEL_ACCOUNT_451(451, "注销账号"),
    CHANGE_PHONE(452, "更换手机号码"),
    FORCE_LOGOUT(453, "强制登出小程序/APP"),
    CLOSE_ORDER_VERIFICATION(454, "关闭历史订单验证"),
    VERIFICATION_CODE_ISSUE(455, "验证码获取相关"),
    LOGIN_PROBLEM(461, "账号登录问题"),

    /*其他业务*/
    OHTHER_BUSINESS(457, "其他业务"),
    ;
    private final int code;
    private final String desc;

    public static Map<Integer, ProblemTypeEnum> codeEnumMap = Maps.newHashMap();

    ProblemTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        for (ProblemTypeEnum problemType : ProblemTypeEnum.values()) {
            codeEnumMap.put(problemType.getCode(),problemType);
        }
    }


    public static ProblemTypeEnum getByCode(Integer code) {
        if (code == null || code == 0) {
            return null;
        }
        ProblemTypeEnum problemType = codeEnumMap.get(code);
        if (Objects.nonNull(problemType)) {
            return problemType;
        }
        return null;
    }
}
