package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.kaordermapping.ApplyRequestHistory;
import cn.quantgroup.customer.model.kaordermapping.ChannelConfigurationResult;
import cn.quantgroup.customer.model.kaordermapping.LoanOrderMapping;
import cn.quantgroup.customer.model.order.CallbackRecordList;
import cn.quantgroup.customer.model.user.OperateLogModel;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;

import java.util.List;
import java.util.Map;

/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */
public interface IKaService {

    JsonResult<LoanOrderMapping> findOrderMapping(OrderQueryParam orderQueryParam);

    /**
     * key 申请订单号 value 渠道订单号
     *
     * @param applyOrderNos
     * @return
     */
    JsonResult<Map<String, String>> findChannelOrderNosByApplyOrderNos(List<String> applyOrderNos);

    JsonResult<List<ChannelConfigurationResult>> getAllChannelConfiguration();

    /**
     * 查询发送通知记录
     *
     * @param applyNo   申请单号
     * @param channelId 渠道号
     * @return
     */
    JsonResult<CallbackRecordList> querySendRecords(String applyNo, Long channelId);

    /**
     * 查询最新渠道进件请求流水
     *
     * @param applyNo
     * @param channelId
     * @return
     */
    JsonResult<ApplyRequestHistory> queryLatestChannelRequestFlows(String applyNo, Long channelId);

    /**
     * 保存操作记录
     * @param model
     */
    void saveOperateLog(OperateLogModel model);
}
