package cn.quantgroup.customer.model.order;

import cn.quantgroup.customer.util.MoneySerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Wang Xiangwei
 * @version 2020/3/11
 */
@Data
public class LoanOrder {
    /**
     * 订单申请号
     */
    private String orderNo;

    /**
     * 借款订单号
     */
    private Long loanId;

    /**
     * 提现渠道号
     */
    private String channelNo;

    /**
     * 提现时间
     */
    private String loanPaidAt;

    /**
     * 资金方
     */
    private String fund;

    /**
     * 合同贷款金额
     */
    private String contractAmount;

    /**
     * 合同贷款期数
     */
    private Integer contractTermNo;

    /**
     * 担保费
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal guaranteeFee;

    /**
     * 其他费用
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal otherFee;

    /**
     * 一次性服务费
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal onceServiceFee;

    /**
     * 月利率
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal monthlyInterestRate;

    /**
     * 当前状态
     */
    private String status;

    /**
     * 推送资金方放款时间
     */
    private String sendLoanPaidAt;

    /**
     * 放款银行卡号
     */
    private String cardNo;

    /**
     * 放款银行卡户名
     */
    private String cardHolderName;

    /**
     * 放款银行名称
     */
    private String bankName;

    /**
     * 是否展示还款计划
     */
    private Boolean showPlans;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date paidAt;
}
