package cn.quantgroup.customer.service.impl;

import static cn.quantgroup.customer.constant.Constant.GSON;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.model.kaordermapping.LoanOrderMapping;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.thirdworkorder.ThirdWorkOrderExportVo;
import cn.quantgroup.customer.service.IKdspService;
import cn.quantgroup.customer.service.http.IHttpService;
import cn.quantgroup.customer.util.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */
@Slf4j
@Service
public class KdspServiceImpl implements IKdspService {


    @Value("${kdsp-operation}")
    private String kdspOperationUrl;

    @Autowired
    private IHttpService httpService;

    @Override
    public JsonResult<List<ThirdWorkOrderExportVo>> getOrderDetailForWorkOder(
        List<String> orderNos,Integer tenantId) {

        if (CollectionUtils.isEmpty(orderNos)){
            return JsonResult.buildSuccessResult("","");
        }
        String url = kdspOperationUrl+"/api/kdsp/op/order/getOrderDetailForWorkOder";
        JsonResult<List<ThirdWorkOrderExportVo>> jsonResult = null;
        try {
            Map<String,String> header = new HashMap<>();
            header.put("qg-tenant-id",tenantId.toString());
            String result = httpService.post(url, header,orderNos);

            TypeReference<JsonResult<List<ThirdWorkOrderExportVo>>> typeToken = new TypeReference<JsonResult<List<ThirdWorkOrderExportVo>>>() {
            };
            jsonResult = JSONTools.deserialize(result, typeToken);
            log.info("工单查询订单详情返回值:{}", result);
        } catch (Exception ex) {
            log.error("工单查询订单详情异常",ex);
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.NET_ERROR.getMessage(), null);
        }
        return  jsonResult;
    }
}
