package cn.quantgroup.customer.rest;
import cn.quantgroup.customer.rest.param.transactionreceipt.TransactionReceiptRecordQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.transaction.*;
import cn.quantgroup.customer.service.ITransactionReceiptRecordService;
import cn.quantgroup.customer.service.http.IHttpService;
import cn.quantgroup.customer.util.FileToZip;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.Synchronized;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/transactionReceiptRecord")
public class TransactionReceiptRecordRest {

    @Autowired
    private ITransactionReceiptRecordService transactionReceiptRecordService;
    @Autowired
    private IHttpService httpService;

    /**
     * 根据筛选条件进行查询
     * @param query
     * @return
     */
    @RequestMapping("/orderQuery/query_page")
    @ResponseBody
    public JsonResult<Page<TransactionReceiptRecordVO>> queryPage(@RequestBody TransactionReceiptRecordQuery query) {
        if (query.getPageNo()== null || query.getPageNo() < 1) {
            log.error("[TransactionReceiptRecordRest_queryPage]查询参数pageNumber错误，pageNo={}", query.getPageNo());
            return JsonResult.buildErrorStateResult("查询参数pageNo错误");
        }
        Integer pageNo = query.getPageNo() - 1;
        query.setPageNo(pageNo);
        if (query.getPageSize() == null) {
            log.error("[workOrderRest_queryPage]查询参数pageSize错误，pageSize={}", query.getPageSize());
            return JsonResult.buildErrorStateResult("查询参数pageSize错误");
        }
        return transactionReceiptRecordService.findRecordsByQuery(query);
    }
    /**
     * 导入excel表格
     */
    @RequestMapping("/orderQuery/importTransactionReceiptRecord")
    @ResponseBody
    @Synchronized
    public JsonResult importTransactionReceiptRecord(@RequestParam("file")MultipartFile file) {
        try{
            return transactionReceiptRecordService.importTransactionReceiptRecord(file);
        }catch(IOException e){
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("上传文件出现错误");
        }
    }
    /**
     * 导出压缩包之前先校验
     */
    @RequestMapping("/orderQuery/checkCanExport")
    public JsonResult checkCanExport() {
        return transactionReceiptRecordService.checkCanExport();
    }

    @RequestMapping("/test")
    public JsonResult test() {
        String userIds="70356056,70356055";
        String url ="http://passportapi-qa2.liangkebang.net/api/sync/listByUserIds";
        Map param = Maps.newHashMap();
        param.put("userIds",userIds);
        String userResult = httpService.get(url,param);
        JSONObject jsonObject = JSONObject.parseObject(userResult);
        String dataStr = jsonObject.getString("data");
        JSONArray userArray = JSONArray.parseArray(dataStr);
        for(int i=0;i<userArray.size();i++){
            JSONObject object= (JSONObject) userArray.get(i);
        }
        return JsonResult.buildSuccessResult("success", userArray);
    }

    @RequestMapping("/testKdsp")
    public JsonResult testKdsp() {
        String url = "http://kdsp-operation-qa2.liangkebang.net/api/kdsp/op/fa-cui/transaction-proof/query";
        try {
            Map<String, String> header = Maps.newHashMap();
            header.put("Content-type", "application/json");
            header.put("qg-tenant-id", "560761");
            Map param = Maps.newHashMap();
            List<Map> paramList =new ArrayList<>();
            //param.put("userId", 70356062);
            //param.put("orderNo", "1495958974917529600");
            param.put("userId", 70356067);
            param.put("orderNo", "1496312159003762688");
            paramList.add(param);
            //得到json字符串
            String result = httpService.post(url, header, paramList);
            //转换成json 对象
            JSONObject json =JSONObject.parseObject(result);
            String jsonResult = json.getString("data");
            String businessCode = json.getString("businessCode");
            if(!"0000".equals(businessCode)){
                return JsonResult.buildErrorStateResult("订单信息查询报错");
            }
            if(jsonResult != null){
                JSONObject jsonObject = JSONObject.parseObject(jsonResult);
                JSONArray jsonArray = jsonObject.getJSONArray("dataList");
                if(jsonArray.isEmpty()){
                    return JsonResult.buildErrorStateResult("未查询到对应的订单信息");
                }
                List<TransactionReceiptVO> transactionReceiptVOList = jsonArray.toJavaList(TransactionReceiptVO.class);
                //生成pdf
                String basicPath="D:\\交易凭证0222";
                String filePath =basicPath +"\\"+"wuq";
                FileToZip.mkdir(filePath);
                filePath = filePath +"\\"+"1493905629528739840"+".pdf";
                transactionReceiptRecordService.generatePDF(transactionReceiptVOList.get(0),filePath);
            }
            return JsonResult.buildSuccessResult("success",null);
        } catch (Exception e) {
            log.error("[TransactionReceiptRecordServiceImpl][exportZipFile] 网络通讯异常,userId:{},ex:{}", e.getMessage());
            return JsonResult.buildErrorStateResult(e.getMessage());
        }
    }
    /**
     * 后台更新交易凭证状态
     * @return
     */
    @RequestMapping("/orderQuery/updateTransactionRecordsStatus")
    @ResponseBody
    public JsonResult updateTransactionRecordsStatus() {
        return transactionReceiptRecordService.updateTransactionRecordsStatus();
    }

    //导出压缩包
    @RequestMapping("/orderQuery/exportTransactionZipFile")
    @ResponseBody
    public JsonResult exportTransactionZipFile(HttpServletRequest request, HttpServletResponse response) throws Exception{
        //try{
            return transactionReceiptRecordService.exportZipFile(request,response);
       /* }catch(Exception e){
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("导出文件出现错误");
        }*/

    }

    //pdf签章后回调接口更新pdf是否签章成功
    @RequestMapping("/orderQuery/updateSignStatus")
    @ResponseBody
    public JsonResult updateSignStatus(@RequestBody TransactionReceiptRecordQuery query) {
        try{
            return transactionReceiptRecordService.updatePDFSignStatus(query.getSuccessList(),query.getFailList());
        }catch(Exception e){
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("更新签章状态失败");
        }

    }

}
