package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.model.kaordermapping.ChannelConfigurationResult;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IKaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 渠道相关
 *
 * @author Wang Xiangwei
 * @version 2020/3/13
 */
@Slf4j
@RestController
@RequestMapping("/channel")
public class ChannelRest {

    @Autowired
    private IKaService kaService;

    @GetMapping("/all")
    public JsonResult<List<ChannelConfigurationResult>> getAllChannel() {

        JsonResult<List<ChannelConfigurationResult>> allChannelConfiguration = kaService.getAllChannelConfiguration();
        return allChannelConfiguration;
    }
}
