package cn.quantgroup.customer.config.http.security;

import cn.quantgroup.customer.constant.Constant;
import org.springframework.context.annotation.Bean;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.HeaderHttpSessionStrategy;
import org.springframework.session.web.http.HttpSessionStrategy;


@EnableRedisHttpSession(maxInactiveIntervalInSeconds = Constant.COOKIE_AND_SESSION_EXPIRE_TIMEOUT_SECONDS, redisNamespace = Constant.CUSTOMER_SESSION_NAMESPACE)
public class WebSessionConfig {
    @Bean(name = "httpSessionStrategy")
    public HttpSessionStrategy httpSessionStrategy() {
        HeaderHttpSessionStrategy strategy = new HeaderHttpSessionStrategy();
        return strategy;
    }

}
