package cn.quantgroup.customer.config.mail;

import java.security.Security;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.Properties;

/**
 * @author jie.feng
 */
@Configuration
public class MailConfig {

    @Value("${customer.transaction.mail.from}")
    private String username;
    @Value("${customer.transaction.mail.host}")
    private String host;
    @Value("${customer.transaction.mail.port}")
    private int port = 465;
    @Value("${customer.transaction.mail.password}")
    private String password;

    @Bean(name = "monitorMailSender")
    public JavaMailSender getSender() {
        Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
        JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
        javaMailSender.setUsername(username);
        javaMailSender.setProtocol("smtp");
        javaMailSender.setHost(host);
        javaMailSender.setPort(port);
        javaMailSender.setDefaultEncoding("UTF-8");
        javaMailSender.setPassword(password);


        Properties prop = new Properties();
        prop.put("mail.smtp.auth", "true");
        prop.put("mail.smtp.timeout", "25000");
        prop.setProperty("mail.smtp.port", Integer.toString(port));
        prop.setProperty("mail.smtp.socketFactory.port", Integer.toString(port));
        prop.setProperty("mail.smtp.socketFactory.fallback", "false");
        prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        prop.setProperty("mail.smtp.socketFactory.port", Integer.toString(port));
        javaMailSender.setJavaMailProperties(prop);
        return javaMailSender;
    }
}