package cn.quantgroup.customer.service;
import cn.quantgroup.customer.rest.vo.transaction.TransactionReceiptRecordVO;
import cn.quantgroup.customer.rest.param.transactionreceipt.TransactionReceiptRecordQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.transaction.TransactionReceiptVO;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public interface ITransactionReceiptRecordService {

    JsonResult<Page<TransactionReceiptRecordVO>> findRecordsByQuery(TransactionReceiptRecordQuery query);

    JsonResult importTransactionReceiptRecord(MultipartFile file) throws IOException;

    void  exportZipFile(HttpServletRequest request, HttpServletResponse response) throws RuntimeException;

    JsonResult  checkCanExport();

    JsonResult updateTransactionRecordsStatus();

    void generatePDF(TransactionReceiptVO transactionReceiptVO, String filePath);

    void deleteRedis(String str);

    String checkRedis(String str);

}
