package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IOrderService;
import cn.quantgroup.customer.service.IXyqbService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Wang Xiangwei
 * @version 2020/3/9
 */

@Slf4j
@RestController
@RequestMapping("/order")
public class OrderRest {

    @Autowired
    private IXyqbService xyqbService;

    @Autowired
    private IOrderService orderService;

    @GetMapping("/loan/{loanId}")
    public JsonResult getLoanOrderDetail(@PathVariable Long loanId){

        return xyqbService.findLoanDetail(loanId);
    }

    @GetMapping("/flowchart/{orderNo}")
    public JsonResult getFlowChart(@PathVariable String orderNo){
        return orderService.findFlowChart(orderNo);
    }

}
