package cn.quantgroup.customer.entity;

import lombok.*;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

@Entity
@Table(name = "offline_repay_submit_record")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class OfflineRepaySubmitRecord {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "serial_no")
    private String serialNo;
    @Column(name = "unique_id")
    private String uniqueId;
    @Column(name = "bills")
    private String bills;
    @Column(name = "curr_term")
    private Integer currTerm;
    @Column(name = "amount")
    private BigDecimal amount;
    @Column(name = "actual_amount")
    private BigDecimal actualAmount;
    @Column(name = "actual_date")
    private Date actualDate;
    @Column(name = "trans_no")
    private String transNo;
    @Column(name = "receive_account")
    private String receiveAccount;
    @Column(name = "receive_account_name")
    private String receiveAccountName;
    @Column(name = "credentials_address")
    private String credentialsAddress;
    @Column(name = "mark")
    private String mark;
    @Column(name = "repay_type")
    private Integer repayType;
    @Column(name = "user_id")
    private Integer userId;
    @Column(name = "name")
    private String name;
    @Column(name = "phone")
    private String phone;
    @Column(name = "id_no")
    private String idNo;
    @Column(name = "repay_status")
    private String repayStatus;
    @Column(name = "approval_status")
    private Integer approvalStatus;
    @Column(name = "create_time")
    private Date createTime;
    @Column(name = "update_time")
    private Date updateTime;
}
